/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import androidx.annotation.OptIn;
import androidx.core.os.BuildCompat;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.PackageUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.compat.ApiHelperForP;
import org.chromium.build.BuildConfig;

public class BuildInfo {
    private static final String TAG = "BuildInfo";
    private static final int MAX_FINGERPRINT_LENGTH = 128;
    private static PackageInfo sBrowserPackageInfo;
    private static ApplicationInfo sBrowserApplicationInfo;
    private static boolean sInitialized;
    public final String hostPackageName;
    public final String hostPackageLabel;
    public final long hostVersionCode;
    public final String packageName;
    public final long versionCode;
    public final String versionName;
    public final String installerPackageName;
    public final String gmsVersionCode;
    public final String abiString;
    public final String androidBuildFingerprint;
    public final String customThemes;
    public final String resourcesVersion;
    public final boolean isTV;
    public final boolean isAutomotive;
    public final int vulkanDeqpLevel;

    @CalledByNative
    private static String[] getAll() {
        return BuildInfo.getInstance().getAllProperties();
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    private String[] getAllProperties() {
        return new String[]{Build.BRAND, Build.DEVICE, Build.ID, Build.MANUFACTURER, Build.MODEL, String.valueOf(Build.VERSION.SDK_INT), Build.TYPE, Build.BOARD, this.hostPackageName, String.valueOf(this.hostVersionCode), this.hostPackageLabel, this.packageName, String.valueOf(this.versionCode), this.versionName, this.androidBuildFingerprint, this.gmsVersionCode, this.installerPackageName, this.abiString, this.customThemes, this.resourcesVersion, String.valueOf(ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion), BuildInfo.isDebugAndroid() ? "1" : "0", this.isTV ? "1" : "0", Build.VERSION.INCREMENTAL, Build.HARDWARE, BuildInfo.isAtLeastT() ? "1" : "0", this.isAutomotive ? "1" : "0", BuildCompat.isAtLeastU() ? "1" : "0", BuildInfo.targetsAtLeastU() ? "1" : "0", Build.VERSION.CODENAME, String.valueOf(this.vulkanDeqpLevel)};
    }

    private static String nullToEmpty(CharSequence seq) {
        return seq == null ? "" : seq.toString();
    }

    public static long packageVersionCode(PackageInfo pi) {
        if (Build.VERSION.SDK_INT >= 28) {
            return ApiHelperForP.getLongVersionCode(pi);
        }
        return pi.versionCode;
    }

    public static void setBrowserPackageInfo(PackageInfo packageInfo) {
        assert (!sInitialized);
        sBrowserPackageInfo = packageInfo;
    }

    public ApplicationInfo getBrowserApplicationInfo() {
        return sBrowserApplicationInfo;
    }

    public static BuildInfo getInstance() {
        if (BuildConfig.IS_FOR_TEST) {
            return new BuildInfo();
        }
        return Holder.INSTANCE;
    }

    private BuildInfo() {
        FeatureInfo[] features;
        boolean isAutomotive;
        sInitialized = true;
        Context appContext = ContextUtils.getApplicationContext();
        String appContextPackageName = appContext.getPackageName();
        PackageManager pm = appContext.getPackageManager();
        String providedHostPackageName = null;
        String providedHostPackageLabel = null;
        String providedPackageName = null;
        String providedPackageVersionName = null;
        Long providedHostVersionCode = null;
        Long providedPackageVersionCode = null;
        if (CommandLine.isInitialized()) {
            CommandLine commandLine = CommandLine.getInstance();
            providedHostPackageName = commandLine.getSwitchValue("host-package-name");
            providedHostPackageLabel = commandLine.getSwitchValue("host-package-label");
            providedPackageName = commandLine.getSwitchValue("package-name");
            providedPackageVersionName = commandLine.getSwitchValue("package-version-name");
            if (commandLine.hasSwitch("host-version-code")) {
                providedHostVersionCode = Long.parseLong(commandLine.getSwitchValue("host-version-code"));
            }
            if (commandLine.hasSwitch("package-version-code")) {
                providedPackageVersionCode = Long.parseLong(commandLine.getSwitchValue("package-version-code"));
            }
        }
        boolean hostInformationProvided = providedHostPackageName != null && providedHostPackageLabel != null && providedHostVersionCode != null && providedPackageName != null && providedPackageVersionName != null && providedPackageVersionCode != null;
        String appInstalledPackageName = appContextPackageName;
        if (hostInformationProvided) {
            this.hostPackageName = providedHostPackageName;
            this.hostPackageLabel = providedHostPackageLabel;
            this.hostVersionCode = providedHostVersionCode;
            this.versionName = providedPackageVersionName;
            this.packageName = providedPackageName;
            this.versionCode = providedPackageVersionCode;
            sBrowserApplicationInfo = appContext.getApplicationInfo();
        } else {
            int hostId;
            String[] packageNames;
            Object sdkQualifiedName = appInstalledPackageName;
            if (ContextUtils.isSdkSandboxProcess() && (packageNames = pm.getPackagesForUid(hostId = Process.myUid() - 10000)).length > 0) {
                appInstalledPackageName = packageNames[0];
                sdkQualifiedName = (String)sdkQualifiedName + ":" + appInstalledPackageName;
            }
            PackageInfo pi = PackageUtils.getPackageInfo(appInstalledPackageName, 0);
            this.hostPackageName = sdkQualifiedName;
            this.hostPackageLabel = BuildInfo.nullToEmpty(pm.getApplicationLabel(pi.applicationInfo));
            this.hostVersionCode = BuildInfo.packageVersionCode(pi);
            if (sBrowserPackageInfo != null) {
                this.packageName = BuildInfo.sBrowserPackageInfo.packageName;
                this.versionCode = BuildInfo.packageVersionCode(sBrowserPackageInfo);
                this.versionName = BuildInfo.nullToEmpty(BuildInfo.sBrowserPackageInfo.versionName);
                sBrowserApplicationInfo = BuildInfo.sBrowserPackageInfo.applicationInfo;
                sBrowserPackageInfo = null;
            } else {
                this.packageName = appContextPackageName;
                this.versionCode = this.hostVersionCode;
                this.versionName = BuildInfo.nullToEmpty(pi.versionName);
                sBrowserApplicationInfo = appContext.getApplicationInfo();
            }
        }
        this.installerPackageName = BuildInfo.nullToEmpty(pm.getInstallerPackageName(appInstalledPackageName));
        PackageInfo gmsPackageInfo = PackageUtils.getPackageInfo("com.google.android.gms", 0);
        this.gmsVersionCode = gmsPackageInfo != null ? String.valueOf(BuildInfo.packageVersionCode(gmsPackageInfo)) : "gms versionCode not available.";
        this.customThemes = String.valueOf(PackageUtils.isPackageInstalled("projekt.substratum"));
        String currentResourcesVersion = "Not Enabled";
        if (BuildConfig.R_STRING_PRODUCT_VERSION != 0) {
            try {
                currentResourcesVersion = ContextUtils.getApplicationContext().getString(BuildConfig.R_STRING_PRODUCT_VERSION);
            }
            catch (Exception e) {
                currentResourcesVersion = "Not found";
            }
        }
        this.resourcesVersion = currentResourcesVersion;
        this.abiString = TextUtils.join((CharSequence)", ", (Object[])Build.SUPPORTED_ABIS);
        this.androidBuildFingerprint = Build.FINGERPRINT.substring(0, Math.min(Build.FINGERPRINT.length(), 128));
        UiModeManager uiModeManager = (UiModeManager)appContext.getSystemService("uimode");
        this.isTV = uiModeManager != null && uiModeManager.getCurrentModeType() == 4;
        try {
            isAutomotive = pm.hasSystemFeature("android.hardware.type.automotive");
        }
        catch (SecurityException e) {
            Log.e(TAG, "Unable to query for Automotive system feature", e);
            isAutomotive = false;
        }
        this.isAutomotive = isAutomotive;
        int vulkanLevel = 0;
        if (Build.VERSION.SDK_INT >= 33 && (features = pm.getSystemAvailableFeatures()) != null) {
            for (FeatureInfo feature : features) {
                if (!"android.software.vulkan.deqp.level".equals(feature.name)) continue;
                vulkanLevel = feature.version;
                break;
            }
        }
        this.vulkanDeqpLevel = vulkanLevel;
    }

    public static boolean isDebugAndroid() {
        return "eng".equals(Build.TYPE) || "userdebug".equals(Build.TYPE);
    }

    public static boolean isDebugApp() {
        int appFlags = ContextUtils.getApplicationContext().getApplicationInfo().flags;
        return (appFlags & 2) != 0;
    }

    public static boolean isDebugAndroidOrApp() {
        return BuildInfo.isDebugAndroid() || BuildInfo.isDebugApp();
    }

    @Deprecated
    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public static boolean isAtLeastT() {
        return BuildCompat.isAtLeastT();
    }

    @Deprecated
    public static boolean targetsAtLeastT() {
        int target = ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion;
        return target >= 33;
    }

    public static boolean targetsAtLeastU() {
        int target = ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion;
        return target >= 34;
    }

    private static class Holder {
        private static final BuildInfo INSTANCE = new BuildInfo();

        private Holder() {
        }
    }
}

