/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.view.LayoutInflater;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.StrictModeContext;
import org.chromium.base.WrappedClassLoader;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.compat.ApiHelperForO;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.build.BuildConfig;

public class BundleUtils {
    private static final String TAG = "BundleUtils";
    private static final String LOADED_SPLITS_KEY = "split_compat_loaded_splits";
    private static Boolean sIsBundle;
    private static final Object sSplitLock;
    private static final ArrayMap<String, ClassLoader> sCachedClassLoaders;
    private static final Map<String, ClassLoader> sInflationClassLoaders;
    private static SplitCompatClassLoader sSplitCompatClassLoaderInstance;
    private static ArrayList<String> sSplitsToRestore;

    public static void resetForTesting() {
        sIsBundle = null;
        sCachedClassLoaders.clear();
        sInflationClassLoaders.clear();
        sSplitCompatClassLoaderInstance = null;
        sSplitsToRestore = null;
    }

    @CalledByNative
    public static boolean isBundleForNative() {
        return BundleUtils.isBundle();
    }

    public static boolean isBundle() {
        if (!BuildConfig.BUNDLES_SUPPORTED) {
            return false;
        }
        assert (sIsBundle != null);
        return sIsBundle;
    }

    public static void setIsBundle(boolean isBundle) {
        sIsBundle = isBundle;
    }

    public static boolean isolatedSplitsEnabled() {
        return BuildConfig.ISOLATED_SPLITS_ENABLED;
    }

    @RequiresApi(api=26)
    private static String getSplitApkPath(String splitName) {
        ApplicationInfo appInfo = ContextUtils.getApplicationContext().getApplicationInfo();
        Object[] splitNames = appInfo.splitNames;
        if (splitNames == null) {
            return null;
        }
        int idx = Arrays.binarySearch(splitNames, splitName);
        return idx < 0 ? null : appInfo.splitSourceDirs[idx];
    }

    public static boolean isIsolatedSplitInstalled(String splitName) {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        return BundleUtils.getSplitApkPath(splitName) != null;
    }

    public static Object getSplitContextLock() {
        return sSplitLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context createIsolatedSplitContext(Context base, String splitName) {
        if (Build.VERSION.SDK_INT < 26) {
            return base;
        }
        try {
            Context context;
            if (BundleUtils.isApplicationContext(base)) {
                context = ApiHelperForO.createContextForSplit(base, splitName);
            } else {
                Object object = BundleUtils.getSplitContextLock();
                synchronized (object) {
                    context = ApiHelperForO.createContextForSplit(base, splitName);
                }
            }
            ClassLoader parent = context.getClassLoader().getParent();
            Context appContext = ContextUtils.getApplicationContext();
            boolean shouldReplaceClassLoader = BundleUtils.isolatedSplitsEnabled() && !parent.equals(BundleUtils.class.getClassLoader()) && appContext != null && !parent.equals(appContext.getClassLoader());
            ArrayMap<String, ClassLoader> arrayMap = sCachedClassLoaders;
            synchronized (arrayMap) {
                ClassLoader cachedClassLoader;
                if (shouldReplaceClassLoader && !sCachedClassLoaders.containsKey((Object)splitName)) {
                    String apkPath = BundleUtils.getSplitApkPath(splitName);
                    sCachedClassLoaders.put((Object)splitName, (Object)new PathClassLoader(apkPath, appContext.getClassLoader()));
                }
                if ((cachedClassLoader = (ClassLoader)sCachedClassLoaders.get((Object)splitName)) != null) {
                    if (!cachedClassLoader.equals(context.getClassLoader())) {
                        shouldReplaceClassLoader = true;
                        BundleUtils.replaceClassLoader(context, cachedClassLoader);
                    }
                } else {
                    sCachedClassLoaders.put((Object)splitName, (Object)context.getClassLoader());
                }
            }
            RecordHistogram.recordBooleanHistogram("Android.IsolatedSplits.ClassLoaderReplaced." + splitName, shouldReplaceClassLoader);
            return context;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void replaceClassLoader(Context baseContext, ClassLoader classLoader) {
        while (baseContext instanceof ContextWrapper) {
            baseContext = ((ContextWrapper)baseContext).getBaseContext();
        }
        try {
            Field classLoaderField = baseContext.getClass().getDeclaredField("mClassLoader");
            classLoaderField.setAccessible(true);
            classLoaderField.set(baseContext, classLoader);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error setting ClassLoader.", e);
        }
    }

    @CalledByNative
    @Nullable
    public static String getNativeLibraryPath(String libraryName, String splitName) {
        try (StrictModeContext ignored = StrictModeContext.allowDiskReads();){
            String path = ((BaseDexClassLoader)BundleUtils.class.getClassLoader()).findLibrary(libraryName);
            if (path != null) {
                String string2 = path;
                return string2;
            }
            ClassLoader classLoader = ContextUtils.getApplicationContext().getClassLoader();
            if (classLoader instanceof BaseDexClassLoader) {
                path = ((BaseDexClassLoader)classLoader).findLibrary(libraryName);
            } else if (classLoader instanceof WrappedClassLoader) {
                path = ((WrappedClassLoader)classLoader).findLibrary(libraryName);
            }
            if (path != null) {
                String string3 = path;
                return string3;
            }
            String string4 = BundleUtils.getSplitApkLibraryPath(libraryName, splitName);
            return string4;
        }
    }

    public static void checkContextClassLoader(Context baseContext, Activity activity) {
        ClassLoader contextClassLoader;
        ClassLoader activityClassLoader = activity.getClass().getClassLoader();
        if (activityClassLoader != (contextClassLoader = baseContext.getClassLoader())) {
            Log.w(TAG, "Mismatched ClassLoaders between Activity and context (fixing): %s", activity.getClass());
            BundleUtils.replaceClassLoader(baseContext, activityClassLoader);
        }
    }

    public static Object newInstance(Context context, String className) {
        Context appContext = ContextUtils.getApplicationContext();
        if (appContext != null && BundleUtils.canLoadClass(appContext.getClassLoader(), className)) {
            context = appContext;
        }
        try {
            return context.getClassLoader().loadClass(className).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Context createContextForInflation(Context context, String splitName) {
        if (!BundleUtils.isIsolatedSplitInstalled(splitName)) {
            return context;
        }
        final ClassLoader splitClassLoader = BundleUtils.registerSplitClassLoaderForInflation(splitName);
        return new ContextWrapper(context){

            public ClassLoader getClassLoader() {
                return splitClassLoader;
            }

            public Object getSystemService(String name) {
                Object ret = super.getSystemService(name);
                if ("layout_inflater".equals(name)) {
                    ret = ((LayoutInflater)ret).cloneInContext((Context)this);
                }
                return ret;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getOrCreateSplitClassLoader(String splitName) {
        ClassLoader ret;
        ArrayMap<String, ClassLoader> arrayMap = sCachedClassLoaders;
        synchronized (arrayMap) {
            ret = (ClassLoader)sCachedClassLoaders.get((Object)splitName);
        }
        if (ret == null) {
            BundleUtils.createIsolatedSplitContext(ContextUtils.getApplicationContext(), splitName);
            arrayMap = sCachedClassLoaders;
            synchronized (arrayMap) {
                ret = (ClassLoader)sCachedClassLoaders.get((Object)splitName);
                assert (ret != null);
            }
        }
        return ret;
    }

    public static ClassLoader registerSplitClassLoaderForInflation(String splitName) {
        ClassLoader splitClassLoader = BundleUtils.getOrCreateSplitClassLoader(splitName);
        sInflationClassLoaders.put(splitName, splitClassLoader);
        return splitClassLoader;
    }

    public static boolean canLoadClass(ClassLoader classLoader, String className) {
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static ClassLoader getSplitCompatClassLoader() {
        if (sSplitCompatClassLoaderInstance == null) {
            sSplitCompatClassLoaderInstance = new SplitCompatClassLoader();
        }
        return sSplitCompatClassLoaderInstance;
    }

    public static void saveLoadedSplits(Bundle outState) {
        outState.putStringArrayList(LOADED_SPLITS_KEY, new ArrayList<String>(sInflationClassLoaders.keySet()));
    }

    public static void restoreLoadedSplits(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        sSplitsToRestore = savedInstanceState.getStringArrayList(LOADED_SPLITS_KEY);
    }

    @Nullable
    private static String getSplitApkLibraryPath(String libraryName, String splitName) {
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        String apkPath = BundleUtils.getSplitApkPath(splitName);
        if (apkPath == null) {
            return null;
        }
        try {
            ApplicationInfo info = ContextUtils.getApplicationContext().getApplicationInfo();
            String primaryCpuAbi = (String)info.getClass().getField("primaryCpuAbi").get(info);
            return apkPath + "!/lib/" + primaryCpuAbi + "/" + System.mapLibraryName(libraryName);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isApplicationContext(Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Application) {
                return true;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return false;
    }

    static {
        sSplitLock = new Object();
        sCachedClassLoaders = new ArrayMap();
        sInflationClassLoaders = Collections.synchronizedMap(new ArrayMap());
    }

    private static class SplitCompatClassLoader
    extends ClassLoader {
        private static final String TAG = "SplitCompatClassLoader";

        public SplitCompatClassLoader() {
            super(ContextUtils.getApplicationContext().getClassLoader());
            Log.i(TAG, "Splits: %s", sSplitsToRestore);
        }

        private Class<?> checkSplitsClassLoaders(String className) throws ClassNotFoundException {
            for (ClassLoader cl : sInflationClassLoaders.values()) {
                try {
                    return cl.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return null;
        }

        @Override
        public Class<?> findClass(String cn) throws ClassNotFoundException {
            Class<?> foundClass = this.checkSplitsClassLoaders(cn);
            if (foundClass != null) {
                return foundClass;
            }
            if (!cn.startsWith("android.")) {
                if (sSplitsToRestore != null) {
                    this.restoreSplitsClassLoaders();
                    foundClass = this.checkSplitsClassLoaders(cn);
                    if (foundClass != null) {
                        return foundClass;
                    }
                }
                Log.w(TAG, "No class %s amongst %s", (Object)cn, (Object)TextUtils.join((CharSequence)"\n", sInflationClassLoaders.keySet()));
            }
            throw new ClassNotFoundException(cn);
        }

        private void restoreSplitsClassLoaders() {
            for (String splitName : sSplitsToRestore) {
                if (sInflationClassLoaders.containsKey(splitName)) continue;
                BundleUtils.registerSplitClassLoaderForInflation(splitName);
            }
            sSplitsToRestore = null;
        }
    }
}

