/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import androidx.annotation.Nullable;
import java.io.File;
import org.chromium.base.BuildInfo;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.supplier.Supplier;

public final class CommandLineInitUtil {
    private static final String COMMAND_LINE_FILE_PATH = "/data/local";
    private static final String COMMAND_LINE_FILE_PATH_DEBUG_APP = "/data/local/tmp";
    private static String sFilenameOverrideForTesting;

    private CommandLineInitUtil() {
    }

    public static void setFilenameOverrideForTesting(String value) {
        sFilenameOverrideForTesting = value;
    }

    public static void initCommandLine(String fileName) {
        CommandLineInitUtil.initCommandLine(fileName, null);
    }

    public static void initCommandLine(String fileName, @Nullable Supplier<Boolean> shouldUseDebugFlags) {
        if (sFilenameOverrideForTesting != null) {
            fileName = sFilenameOverrideForTesting;
        }
        assert (!CommandLine.isInitialized());
        File commandLineFile = new File(COMMAND_LINE_FILE_PATH_DEBUG_APP, fileName);
        boolean debugFlagsExist = commandLineFile.exists();
        if (!debugFlagsExist || !CommandLineInitUtil.shouldUseDebugCommandLine(shouldUseDebugFlags)) {
            commandLineFile = new File(COMMAND_LINE_FILE_PATH, fileName);
        }
        CommandLine.initFromFile(commandLineFile.getPath());
    }

    private static boolean shouldUseDebugCommandLine(@Nullable Supplier<Boolean> shouldUseDebugFlags) {
        if (shouldUseDebugFlags != null && shouldUseDebugFlags.get().booleanValue()) {
            return true;
        }
        Context context = ContextUtils.getApplicationContext();
        return context.getPackageName().equals(CommandLineInitUtil.getDebugApp(context)) || BuildInfo.isDebugAndroid();
    }

    private static String getDebugApp(Context context) {
        boolean adbEnabled;
        boolean bl = adbEnabled = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"adb_enabled", (int)0) == 1;
        if (adbEnabled) {
            return Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"debug_app");
        }
        return null;
    }
}

