/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import org.chromium.base.CommandLine;
import org.chromium.build.annotations.CheckDiscard;
import org.jni_zero.GEN_JNI;
import org.jni_zero.JniStaticTestMocker;
import org.jni_zero.NativeLibraryLoadedStatus;

@CheckDiscard(value="crbug.com/993421")
class CommandLineJni
implements CommandLine.Natives {
    private static CommandLine.Natives testInstance;
    public static final JniStaticTestMocker<CommandLine.Natives> TEST_HOOKS;

    CommandLineJni() {
    }

    @Override
    public void appendSwitch(String switchString) {
        GEN_JNI.org_chromium_base_CommandLine_appendSwitch(switchString);
    }

    @Override
    public void appendSwitchWithValue(String switchString, String value) {
        GEN_JNI.org_chromium_base_CommandLine_appendSwitchWithValue(switchString, value);
    }

    @Override
    public void appendSwitchesAndArguments(String[] array2) {
        GEN_JNI.org_chromium_base_CommandLine_appendSwitchesAndArguments(array2);
    }

    @Override
    public String getSwitchValue(String switchString) {
        return GEN_JNI.org_chromium_base_CommandLine_getSwitchValue(switchString);
    }

    @Override
    public String[] getSwitchesFlattened() {
        return GEN_JNI.org_chromium_base_CommandLine_getSwitchesFlattened();
    }

    @Override
    public boolean hasSwitch(String switchString) {
        return GEN_JNI.org_chromium_base_CommandLine_hasSwitch(switchString);
    }

    @Override
    public void init(String[] args) {
        GEN_JNI.org_chromium_base_CommandLine_init(args);
    }

    @Override
    public void removeSwitch(String switchString) {
        GEN_JNI.org_chromium_base_CommandLine_removeSwitch(switchString);
    }

    public static CommandLine.Natives get() {
        if (GEN_JNI.TESTING_ENABLED) {
            if (testInstance != null) {
                return testInstance;
            }
            if (GEN_JNI.REQUIRE_MOCK) {
                throw new UnsupportedOperationException("No mock found for the native implementation of CommandLine.Natives. The current configuration requires implementations be mocked.");
            }
        }
        NativeLibraryLoadedStatus.checkLoaded();
        return new CommandLineJni();
    }

    static {
        TEST_HOOKS = new JniStaticTestMocker<CommandLine.Natives>(){

            @Override
            public void setInstanceForTesting(CommandLine.Natives instance) {
                if (!GEN_JNI.TESTING_ENABLED) {
                    throw new RuntimeException("Tried to set a JNI mock when mocks aren't enabled!");
                }
                testInstance = instance;
            }
        };
    }
}

