/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;

public abstract class ContentUriUtils {
    private static final String TAG = "ContentUriUtils";
    private static FileProviderUtil sFileProviderUtil;
    private static final Object sLock;

    private ContentUriUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileProviderUtil(FileProviderUtil util) {
        Object object = sLock;
        synchronized (object) {
            sFileProviderUtil = util;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri getContentUriFromFile(File file) {
        Object object = sLock;
        synchronized (object) {
            if (sFileProviderUtil != null) {
                return sFileProviderUtil.getContentUriFromFile(file);
            }
        }
        return null;
    }

    @CalledByNative
    public static int openContentUriForRead(String uriString) {
        AssetFileDescriptor afd = ContentUriUtils.getAssetFileDescriptor(uriString);
        if (afd != null) {
            return afd.getParcelFileDescriptor().detachFd();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static boolean contentUriExists(String uriString) {
        AssetFileDescriptor asf = null;
        try {
            asf = ContentUriUtils.getAssetFileDescriptor(uriString);
            boolean bl = asf != null;
            return bl;
        }
        finally {
            if (asf != null) {
                try {
                    asf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @CalledByNative
    public static String getMimeType(String uriString) {
        ContentResolver resolver = ContextUtils.getApplicationContext().getContentResolver();
        Uri uri = Uri.parse((String)uriString);
        if (ContentUriUtils.isVirtualDocument(uri)) {
            String[] streamTypes = resolver.getStreamTypes(uri, "*/*");
            return streamTypes != null && streamTypes.length > 0 ? streamTypes[0] : null;
        }
        return resolver.getType(uri);
    }

    private static AssetFileDescriptor getAssetFileDescriptor(String uriString) {
        block7: {
            ContentResolver resolver = ContextUtils.getApplicationContext().getContentResolver();
            Uri uri = Uri.parse((String)uriString);
            try {
                if (ContentUriUtils.isVirtualDocument(uri)) {
                    String[] streamTypes = resolver.getStreamTypes(uri, "*/*");
                    if (streamTypes == null || streamTypes.length <= 0) break block7;
                    AssetFileDescriptor afd = resolver.openTypedAssetFileDescriptor(uri, streamTypes[0], null);
                    if (afd != null && afd.getStartOffset() != 0L) {
                        try {
                            afd.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SecurityException("Cannot open files with non-zero offset type.");
                    }
                    return afd;
                }
                ParcelFileDescriptor pfd = resolver.openFileDescriptor(uri, "r");
                if (pfd != null) {
                    return new AssetFileDescriptor(pfd, 0L, -1L);
                }
            }
            catch (Exception e) {
                Log.w(TAG, "Cannot open content uri: %s", (Object)uriString, (Object)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDisplayName(Uri uri, Context context, String columnField) {
        if (uri == null) {
            return "";
        }
        ContentResolver contentResolver = context.getContentResolver();
        try (Cursor cursor = contentResolver.query(uri, null, null, null, null);){
            String ext;
            String[] mimeTypes;
            if (cursor == null) return "";
            if (cursor.getCount() < 1) return "";
            cursor.moveToFirst();
            int displayNameIndex = cursor.getColumnIndex(columnField);
            if (displayNameIndex == -1) {
                String string2 = "";
                return string2;
            }
            Object displayName = cursor.getString(displayNameIndex);
            if (ContentUriUtils.hasVirtualFlag(cursor) && (mimeTypes = contentResolver.getStreamTypes(uri, "*/*")) != null && mimeTypes.length > 0 && (ext = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeTypes[0])) != null) {
                displayName = (String)displayName + "." + ext;
            }
            String string3 = displayName;
            return string3;
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    @Nullable
    @CalledByNative
    public static String maybeGetDisplayName(String uriString) {
        Uri uri = Uri.parse((String)uriString);
        try {
            String displayName = ContentUriUtils.getDisplayName(uri, ContextUtils.getApplicationContext(), "_display_name");
            return TextUtils.isEmpty((CharSequence)displayName) ? null : displayName;
        }
        catch (Exception e) {
            Log.w(TAG, "Cannot open content uri: %s", (Object)uriString, (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isVirtualDocument(Uri uri) {
        if (uri == null) {
            return false;
        }
        if (!DocumentsContract.isDocumentUri((Context)ContextUtils.getApplicationContext(), (Uri)uri)) {
            return false;
        }
        ContentResolver contentResolver = ContextUtils.getApplicationContext().getContentResolver();
        try (Cursor cursor = contentResolver.query(uri, null, null, null, null);){
            if (cursor == null) return false;
            if (cursor.getCount() < 1) return false;
            cursor.moveToFirst();
            boolean bl = ContentUriUtils.hasVirtualFlag(cursor);
            return bl;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private static boolean hasVirtualFlag(Cursor cursor) {
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        int index = cursor.getColumnIndex("flags");
        return index > -1 && (cursor.getLong(index) & 0x200L) != 0L;
    }

    public static boolean isContentUri(String uri) {
        if (uri == null) {
            return false;
        }
        Uri parsedUri = Uri.parse((String)uri);
        return parsedUri != null && "content".equals(parsedUri.getScheme());
    }

    @CalledByNative
    public static boolean delete(String uriString) {
        assert (ContentUriUtils.isContentUri(uriString));
        Uri parsedUri = Uri.parse((String)uriString);
        ContentResolver resolver = ContextUtils.getApplicationContext().getContentResolver();
        return resolver.delete(parsedUri, null, null) > 0;
    }

    @CalledByNative
    public static String getContentUriFromFilePath(String filePathString) {
        try {
            Uri contentUri = ContentUriUtils.getContentUriFromFile(new File(filePathString));
            if (contentUri != null) {
                return contentUri.toString();
            }
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Cannot retrieve content uri from file: %s", (Object)filePathString, (Object)e);
        }
        return null;
    }

    static {
        sLock = new Object();
    }

    public static interface FileProviderUtil {
        public Uri getContentUriFromFile(File var1);
    }
}

