/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.chromium.base.ContentUriUtils;
import org.chromium.base.FileUtilsJni;
import org.chromium.base.Log;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class FileUtils {
    private static final String TAG = "FileUtils";
    public static Function<String, Boolean> DELETE_ALL = filepath -> true;

    public static boolean recursivelyDeleteFile(File currentFile, Function<String, Boolean> canDelete) {
        boolean ret;
        File[] files;
        if (!currentFile.exists()) {
            currentFile.delete();
            return true;
        }
        if (canDelete != null && !canDelete.apply(currentFile.getPath()).booleanValue()) {
            return true;
        }
        if (currentFile.isDirectory() && (files = currentFile.listFiles()) != null) {
            for (File file : files) {
                FileUtils.recursivelyDeleteFile(file, canDelete);
            }
        }
        if (!(ret = currentFile.delete())) {
            Log.e(TAG, "Failed to delete: %s", (Object)currentFile);
        }
        return ret;
    }

    public static void batchDeleteFiles(List<String> filePaths, Function<String, Boolean> canDelete) {
        for (String filePath : filePaths) {
            if (canDelete != null && !canDelete.apply(filePath).booleanValue()) continue;
            if (ContentUriUtils.isContentUri(filePath)) {
                ContentUriUtils.delete(filePath);
                continue;
            }
            File file = new File(filePath);
            if (!file.exists()) continue;
            FileUtils.recursivelyDeleteFile(file, canDelete);
        }
    }

    public static long getFileSizeBytes(File file) {
        if (file == null) {
            return 0L;
        }
        if (file.isDirectory()) {
            long size = 0L;
            File[] files = file.listFiles();
            if (files == null) {
                return size;
            }
            for (File f : files) {
                size += FileUtils.getFileSizeBytes(f);
            }
            return size;
        }
        return file.length();
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int amountRead;
        byte[] buffer = new byte[8192];
        while ((amountRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, amountRead);
        }
    }

    public static void copyStreamToFile(InputStream is, File outFile) throws IOException {
        File tmpOutputFile = new File(outFile.getPath() + ".tmp");
        try (FileOutputStream os = new FileOutputStream(tmpOutputFile);){
            Log.i(TAG, "Writing to %s", (Object)outFile);
            FileUtils.copyStream(is, os);
        }
        if (!tmpOutputFile.renameTo(outFile)) {
            throw new IOException();
        }
    }

    @NonNull
    public static byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        FileUtils.copyStream(inputStream, data);
        return data.toByteArray();
    }

    public static Uri getUriForFile(File file) {
        Uri uri = null;
        try {
            uri = ContentUriUtils.getContentUriFromFile(file);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Could not create content uri: " + e);
        }
        if (uri == null) {
            uri = Uri.fromFile((File)file);
        }
        return uri;
    }

    public static String getExtension(String file) {
        int lastDot;
        int lastSep = file.lastIndexOf(47);
        if (lastSep >= (lastDot = file.lastIndexOf(46))) {
            return "";
        }
        return file.substring(lastDot + 1).toLowerCase(Locale.US);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Bitmap queryBitmapFromContentProvider(Context context, Uri uri) {
        try (ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");){
            if (parcelFileDescriptor == null) {
                Log.w(TAG, "Null ParcelFileDescriptor from uri " + uri);
                Bitmap bitmap = null;
                return bitmap;
            }
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            if (fileDescriptor == null) {
                Log.w(TAG, "Null FileDescriptor from uri " + uri);
                Bitmap bitmap = null;
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor);
            if (bitmap == null) {
                Log.w(TAG, "Failed to decode image from uri " + uri);
                Bitmap bitmap2 = null;
                return bitmap2;
            }
            Bitmap bitmap3 = bitmap;
            return bitmap3;
        }
        catch (IOException e) {
            Log.w(TAG, "IO exception when reading uri " + uri);
            return null;
        }
    }

    public static String getAbsoluteFilePath(String filePath) {
        return FileUtilsJni.get().getAbsoluteFilePath(filePath);
    }

    public static interface Natives {
        public String getAbsoluteFilePath(String var1);
    }
}

