/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.util.HashMap;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class Flag {
    private static HashMap<String, Flag> sFlagsCreated = new HashMap();
    protected final String mFeatureName;
    protected Boolean mValue;

    protected Flag(String featureName) {
        assert (!sFlagsCreated.containsKey(featureName)) : "Duplicate flag creation for feature: " + featureName;
        this.mFeatureName = featureName;
        sFlagsCreated.put(this.mFeatureName, this);
    }

    public String getFeatureName() {
        return this.mFeatureName;
    }

    public abstract boolean isEnabled();

    protected abstract void clearInMemoryCachedValueForTesting();

    public static void resetFlagsForTesting() {
        Flag.resetAllInMemoryCachedValuesForTesting();
        sFlagsCreated.clear();
    }

    public static void resetAllInMemoryCachedValuesForTesting() {
        for (Flag flag : sFlagsCreated.values()) {
            flag.clearInMemoryCachedValueForTesting();
        }
    }
}

