/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.util.Map;
import org.chromium.base.BundleUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.build.annotations.MainDex;

@MainDex
public class JNIUtils {
    private static final String TAG = "JNIUtils";
    private static ClassLoader sJniClassLoader;

    @CalledByNative
    private static ClassLoader getSplitClassLoader(String splitName) {
        if (!splitName.isEmpty()) {
            boolean isInstalled = BundleUtils.isIsolatedSplitInstalled(splitName);
            Log.i(TAG, "Init JNI Classloader for %s. isInstalled=%b", (Object)splitName, (Object)isInstalled);
            if (isInstalled) {
                return BundleUtils.getOrCreateSplitClassLoader(splitName);
            }
        }
        return sJniClassLoader != null ? sJniClassLoader : JNIUtils.class.getClassLoader();
    }

    public static void setClassLoader(ClassLoader classLoader) {
        sJniClassLoader = classLoader;
    }

    public static <K, V> void splitMap(Map<K, V> map, K[] outKeys, V[] outValues) {
        assert (map.size() == outKeys.length);
        assert (outValues.length == outKeys.length);
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            outKeys[i] = entry.getKey();
            outValues[i] = entry.getValue();
            ++i;
        }
    }
}

