/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Locale;
import org.chromium.base.CommandLine;
import org.chromium.base.annotations.CalledByNative;

public class LocaleUtils {
    private LocaleUtils() {
    }

    public static String getUpdatedLanguageForChromium(String language) {
        switch (language) {
            case "gom": {
                return "kok";
            }
            case "in": {
                return "id";
            }
            case "iw": {
                return "he";
            }
            case "ji": {
                return "yi";
            }
            case "jw": {
                return "jv";
            }
            case "tl": {
                return "fil";
            }
        }
        return language;
    }

    @VisibleForTesting
    public static Locale getUpdatedLocaleForChromium(Locale locale) {
        String language = locale.getLanguage();
        String languageForChrome = LocaleUtils.getUpdatedLanguageForChromium(language);
        if (languageForChrome.equals(language)) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(languageForChrome).build();
    }

    public static String getUpdatedLanguageForAndroid(String language) {
        switch (language) {
            case "und": {
                return "";
            }
            case "fil": {
                return "tl";
            }
        }
        return language;
    }

    @VisibleForTesting
    public static Locale getUpdatedLocaleForAndroid(Locale locale) {
        String language = locale.getLanguage();
        String languageForAndroid = LocaleUtils.getUpdatedLanguageForAndroid(language);
        if (languageForAndroid.equals(language)) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(languageForAndroid).build();
    }

    public static Locale forLanguageTag(String languageTag) {
        Locale locale = Locale.forLanguageTag(languageTag);
        return LocaleUtils.getUpdatedLocaleForAndroid(locale);
    }

    public static String toLanguageTag(Locale locale) {
        String language = LocaleUtils.getUpdatedLanguageForChromium(locale.getLanguage());
        String country = locale.getCountry();
        if (language.equals("no") && country.equals("NO") && locale.getVariant().equals("NY")) {
            return "nn-NO";
        }
        return country.isEmpty() ? language : language + "-" + country;
    }

    @RequiresApi(value=24)
    public static String toLanguageTags(LocaleList localeList) {
        ArrayList<String> newLocaleList = new ArrayList<String>();
        for (int i = 0; i < localeList.size(); ++i) {
            Locale locale = LocaleUtils.getUpdatedLocaleForChromium(localeList.get(i));
            newLocaleList.add(LocaleUtils.toLanguageTag(locale));
        }
        return TextUtils.join((CharSequence)",", newLocaleList);
    }

    public static String toBaseLanguage(String languageTag) {
        int pos = languageTag.indexOf(45);
        if (pos < 0) {
            return languageTag;
        }
        return languageTag.substring(0, pos);
    }

    public static boolean isBaseLanguageEqual(String first, String second) {
        return TextUtils.equals((CharSequence)LocaleUtils.toBaseLanguage(first), (CharSequence)LocaleUtils.toBaseLanguage(second));
    }

    @CalledByNative
    public static String getDefaultLocaleString() {
        return LocaleUtils.toLanguageTag(Locale.getDefault());
    }

    @CalledByNative
    public static String getDefaultLocaleListString() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleUtils.toLanguageTags(LocaleList.getDefault());
        }
        return LocaleUtils.getDefaultLocaleString();
    }

    @CalledByNative
    private static String getDefaultCountryCode() {
        CommandLine commandLine = CommandLine.getInstance();
        return commandLine.hasSwitch("default-country-code") ? commandLine.getSwitchValue("default-country-code") : Locale.getDefault().getCountry();
    }

    public static String getConfigurationLanguage(Configuration config) {
        Locale locale = config.locale;
        return locale != null ? locale.toLanguageTag() : "";
    }

    public static String getContextLanguage(Context context) {
        return LocaleUtils.getConfigurationLanguage(context.getResources().getConfiguration());
    }

    public static void updateConfig(Context base, Configuration config, String languageTag) {
        if (Build.VERSION.SDK_INT >= 24) {
            ApisN.setConfigLocales(base, config, languageTag);
        } else {
            config.setLocale(Locale.forLanguageTag(languageTag));
        }
    }

    public static void setDefaultLocalesFromConfiguration(Configuration config) {
        if (Build.VERSION.SDK_INT >= 24) {
            ApisN.setLocaleList(config);
        } else {
            Locale.setDefault(config.locale);
        }
    }

    @RequiresApi(value=24)
    @VisibleForTesting
    static class ApisN {
        ApisN() {
        }

        static void setConfigLocales(Context base, Configuration config, String language) {
            LocaleList updatedLocales = ApisN.prependToLocaleList(language, base.getResources().getConfiguration().getLocales());
            config.setLocales(updatedLocales);
        }

        static void setLocaleList(Configuration config) {
            LocaleList.setDefault((LocaleList)config.getLocales());
        }

        static LocaleList prependToLocaleList(String languageTag, LocaleList localeList) {
            String languageList = localeList.toLanguageTags();
            String pattern = String.format("(^|,)%1$s$|%1$s,", languageTag);
            languageList = languageList.replaceFirst(pattern, "");
            return LocaleList.forLanguageTags((String)String.format("%1$s,%2$s", languageTag, languageList));
        }
    }
}

