/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.util.Locale;
import org.chromium.build.annotations.AlwaysInline;
import org.chromium.build.annotations.CheckDiscard;
import org.chromium.build.annotations.DoNotInline;

public class Log {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;

    private Log() {
    }

    private static String formatLog(String messageTemplate, Throwable tr, Object ... params) {
        if (params != null && (tr == null && params.length > 0 || params.length > 1)) {
            messageTemplate = String.format(Locale.US, messageTemplate, params);
        }
        return messageTemplate;
    }

    @AlwaysInline
    public static String normalizeTag(String tag) {
        return "cr_" + tag;
    }

    private static String formatLogWithStack(String messageTemplate, Throwable tr, Object ... params) {
        return "[" + Log.getCallOrigin() + "] " + Log.formatLog(messageTemplate, tr, params);
    }

    private static boolean isDebug() {
        return true;
    }

    public static boolean isLoggable(String tag, int level) {
        if (!Log.isDebug() && level <= 4) {
            return false;
        }
        return android.util.Log.isLoggable((String)tag, (int)level);
    }

    @CheckDiscard(value="crbug.com/1231625")
    public static void v(String tag, String messageTemplate, Object ... args) {
        if (!Log.isDebug()) {
            return;
        }
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLogWithStack(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.v((String)tag, (String)message, (Throwable)tr);
        } else {
            android.util.Log.v((String)tag, (String)message);
        }
    }

    @CheckDiscard(value="crbug.com/1231625")
    public static void d(String tag, String messageTemplate, Object ... args) {
        if (!Log.isDebug()) {
            return;
        }
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLogWithStack(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.d((String)tag, (String)message, (Throwable)tr);
        } else {
            android.util.Log.d((String)tag, (String)message);
        }
    }

    public static void i(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.i((String)tag, (String)message, (Throwable)tr);
        } else {
            android.util.Log.i((String)tag, (String)message);
        }
    }

    @AlwaysInline
    public static void i(String tag, String message) {
        android.util.Log.i((String)Log.normalizeTag(tag), (String)message);
    }

    @AlwaysInline
    public static void i(String tag, String message, Throwable t) {
        android.util.Log.i((String)Log.normalizeTag(tag), (String)message, (Throwable)t);
    }

    @DoNotInline
    public static void i(String tag, String messageTemplate, Object o) {
        Log.i(tag, messageTemplate, new Object[]{o});
    }

    @DoNotInline
    public static void i(String tag, String messageTemplate, Object o1, Object o2) {
        Log.i(tag, messageTemplate, new Object[]{o1, o2});
    }

    public static void w(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.w((String)tag, (String)message, (Throwable)tr);
        } else {
            android.util.Log.w((String)tag, (String)message);
        }
    }

    @AlwaysInline
    public static void w(String tag, String message) {
        android.util.Log.w((String)Log.normalizeTag(tag), (String)message);
    }

    @AlwaysInline
    public static void w(String tag, String message, Throwable t) {
        android.util.Log.w((String)Log.normalizeTag(tag), (String)message, (Throwable)t);
    }

    @DoNotInline
    public static void w(String tag, String messageTemplate, Object o) {
        Log.w(tag, messageTemplate, new Object[]{o});
    }

    @DoNotInline
    public static void w(String tag, String messageTemplate, Object o1, Object o2) {
        Log.w(tag, messageTemplate, new Object[]{o1, o2});
    }

    public static void e(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.e((String)tag, (String)message, (Throwable)tr);
        } else {
            android.util.Log.e((String)tag, (String)message);
        }
    }

    @AlwaysInline
    public static void e(String tag, String message) {
        android.util.Log.e((String)Log.normalizeTag(tag), (String)message);
    }

    @AlwaysInline
    public static void e(String tag, String message, Throwable t) {
        android.util.Log.e((String)Log.normalizeTag(tag), (String)message, (Throwable)t);
    }

    @DoNotInline
    public static void e(String tag, String messageTemplate, Object o) {
        Log.e(tag, messageTemplate, new Object[]{o});
    }

    @DoNotInline
    public static void e(String tag, String messageTemplate, Object o1, Object o2) {
        Log.e(tag, messageTemplate, new Object[]{o1, o2});
    }

    public static void wtf(String tag, String messageTemplate, Object ... args) {
        Throwable tr = Log.getThrowableToLog(args);
        String message = Log.formatLog(messageTemplate, tr, args);
        tag = Log.normalizeTag(tag);
        if (tr != null) {
            android.util.Log.wtf((String)tag, (String)message, (Throwable)tr);
        } else {
            android.util.Log.wtf((String)tag, (String)message);
        }
    }

    public static String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    private static Throwable getThrowableToLog(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        Object lastArg = args[args.length - 1];
        if (!(lastArg instanceof Throwable)) {
            return null;
        }
        return (Throwable)lastArg;
    }

    @CheckDiscard(value="crbug.com/1231625")
    private static String getCallOrigin() {
        int callerStackIndex;
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        String logClassName = Log.class.getName();
        for (callerStackIndex = 0; callerStackIndex < st.length; ++callerStackIndex) {
            if (!st[callerStackIndex].getClassName().equals(logClassName)) continue;
            callerStackIndex += 3;
            break;
        }
        return st[callerStackIndex].getFileName() + ":" + st[callerStackIndex].getLineNumber();
    }
}

