/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

public class MathUtils {
    public static final float EPSILON = 0.001f;

    private MathUtils() {
    }

    public static int clamp(int value, int a, int b) {
        int max;
        int min = a > b ? b : a;
        int n = max = a > b ? a : b;
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        return value;
    }

    public static long clamp(long value, long a, long b) {
        long max;
        long min = a > b ? b : a;
        long l = max = a > b ? a : b;
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        return value;
    }

    public static float clamp(float value, float a, float b) {
        float max;
        float min = a > b ? b : a;
        float f = max = a > b ? a : b;
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        return value;
    }

    public static int positiveModulo(int a, int b) {
        int mod = a % b;
        return mod >= 0 ? mod : mod + b;
    }

    public static float interpolate(float value, float target, float speed) {
        return value + (target - value) * speed;
    }

    public static float smoothstep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static float scaleToFitTargetSize(int[] dimensions, int targetWidth, int targetHeight) {
        if (dimensions.length < 2 || dimensions[0] <= 0 || dimensions[1] <= 0) {
            throw new IllegalArgumentException("Expected dimensions to have length >= 2 && dimensions[0] > 0 && dimensions[1] > 0");
        }
        float scale = Math.max((float)targetWidth / (float)dimensions[0], (float)targetHeight / (float)dimensions[1]);
        dimensions[0] = (int)((float)dimensions[0] * scale);
        dimensions[1] = (int)((float)dimensions[1] * scale);
        return scale;
    }

    public static int flipSignIf(int value, boolean flipSign) {
        return flipSign ? -value : value;
    }

    public static float flipSignIf(float value, boolean flipSign) {
        return flipSign ? -value : value;
    }

    public static int compareLongs(long lhs, long rhs) {
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    public static boolean areFloatsEqual(float f1, float f2) {
        return Math.abs(f1 - f2) < 0.001f;
    }

    public static float distance(float x1, float y1, float x2, float y2) {
        float xDist = x2 - x1;
        float yDist = y2 - y1;
        return (float)Math.sqrt(xDist * xDist + yDist * yDist);
    }

    public static float map(float value, float fromStart, float fromStop, float toStart, float toStop) {
        return toStart + (toStop - toStart) * ((value - fromStart) / (fromStop - fromStart));
    }

    public static double roundTwoDecimalPlaces(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }
}

