/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import org.chromium.base.MemoryPressureListenerJni;
import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.memory.MemoryPressureCallback;
import org.chromium.build.annotations.MainDex;

@MainDex
public class MemoryPressureListener {
    private static final String ACTION_LOW_MEMORY = "org.chromium.base.ACTION_LOW_MEMORY";
    private static final String ACTION_TRIM_MEMORY = "org.chromium.base.ACTION_TRIM_MEMORY";
    private static final String ACTION_TRIM_MEMORY_RUNNING_CRITICAL = "org.chromium.base.ACTION_TRIM_MEMORY_RUNNING_CRITICAL";
    private static final String ACTION_TRIM_MEMORY_MODERATE = "org.chromium.base.ACTION_TRIM_MEMORY_MODERATE";
    private static ObserverList<MemoryPressureCallback> sCallbacks;

    @CalledByNative
    private static void addNativeCallback() {
        ThreadUtils.assertOnUiThread();
        MemoryPressureListener.addCallback(pressure -> MemoryPressureListenerJni.get().onMemoryPressure(pressure));
    }

    public static void addCallback(MemoryPressureCallback callback) {
        ThreadUtils.assertOnUiThread();
        if (sCallbacks == null) {
            sCallbacks = new ObserverList();
        }
        sCallbacks.addObserver(callback);
    }

    public static void removeCallback(MemoryPressureCallback callback) {
        ThreadUtils.assertOnUiThread();
        if (sCallbacks == null) {
            return;
        }
        sCallbacks.removeObserver(callback);
    }

    public static void notifyMemoryPressure(int pressure) {
        ThreadUtils.assertOnUiThread();
        if (sCallbacks == null) {
            return;
        }
        for (MemoryPressureCallback callback : sCallbacks) {
            callback.onPressure(pressure);
        }
    }

    public static boolean handleDebugIntent(Activity activity, String action) {
        ThreadUtils.assertOnUiThread();
        if (ACTION_LOW_MEMORY.equals(action)) {
            MemoryPressureListener.simulateLowMemoryPressureSignal(activity);
        } else if (ACTION_TRIM_MEMORY.equals(action)) {
            MemoryPressureListener.simulateTrimMemoryPressureSignal(activity, 80);
        } else if (ACTION_TRIM_MEMORY_RUNNING_CRITICAL.equals(action)) {
            MemoryPressureListener.simulateTrimMemoryPressureSignal(activity, 15);
        } else if (ACTION_TRIM_MEMORY_MODERATE.equals(action)) {
            MemoryPressureListener.simulateTrimMemoryPressureSignal(activity, 60);
        } else {
            return false;
        }
        return true;
    }

    private static void simulateLowMemoryPressureSignal(Activity activity) {
        activity.getApplication().onLowMemory();
        activity.onLowMemory();
    }

    private static void simulateTrimMemoryPressureSignal(Activity activity, int level) {
        activity.getApplication().onTrimMemory(level);
        activity.onTrimMemory(level);
    }

    static interface Natives {
        public void onMemoryPressure(int var1);
    }
}

