/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.TransactionTooLargeException;
import java.util.Collections;
import java.util.List;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.StrictModeContext;

public class PackageManagerUtils {
    private static final String TAG = "PackageManagerUtils";
    public static final Intent BROWSER_INTENT = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").setData(Uri.fromParts((String)"http", (String)"", null));

    public static ResolveInfo resolveActivity(Intent intent, int flags) {
        StrictModeContext ignored = StrictModeContext.allowDiskWrites();
        try {
            PackageManager pm = ContextUtils.getApplicationContext().getPackageManager();
            ResolveInfo resolveInfo = pm.resolveActivity(intent, flags);
            if (ignored != null) {
                ignored.close();
            }
            return resolveInfo;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                PackageManagerUtils.handleExpectedExceptionsOrRethrow(e, intent);
                return null;
            }
        }
    }

    public static List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        StrictModeContext ignored = StrictModeContext.allowDiskReads();
        try {
            PackageManager pm = ContextUtils.getApplicationContext().getPackageManager();
            List list = pm.queryIntentActivities(intent, flags);
            if (ignored != null) {
                ignored.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                PackageManagerUtils.handleExpectedExceptionsOrRethrow(e, intent);
                return Collections.emptyList();
            }
        }
    }

    public static boolean canResolveActivity(Intent intent, int flags) {
        return !PackageManagerUtils.queryIntentActivities(intent, flags).isEmpty();
    }

    public static boolean canResolveActivity(Intent intent) {
        return PackageManagerUtils.canResolveActivity(intent, 0);
    }

    public static Intent getQueryInstalledHomeLaunchersIntent() {
        return new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
    }

    public static ResolveInfo resolveDefaultWebBrowserActivity() {
        return PackageManagerUtils.resolveActivity(BROWSER_INTENT, 65536);
    }

    public static List<ResolveInfo> queryAllWebBrowsersInfo() {
        int flags = 983040;
        return PackageManagerUtils.queryIntentActivities(BROWSER_INTENT, flags);
    }

    public static List<ResolveInfo> queryAllLaunchersInfo() {
        return PackageManagerUtils.queryIntentActivities(PackageManagerUtils.getQueryInstalledHomeLaunchersIntent(), 131072);
    }

    private static void handleExpectedExceptionsOrRethrow(RuntimeException e, Intent intent) {
        if (!(e instanceof NullPointerException) && !(e.getCause() instanceof TransactionTooLargeException)) {
            throw e;
        }
        Log.e(TAG, "Could not resolve Activity for intent " + intent.toString(), e);
    }
}

