/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.BuildInfo;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;

public class PackageUtils {
    private static final String TAG = "PackageUtils";
    private static final char[] HEX_CHAR_LOOKUP = "0123456789ABCDEF".toCharArray();

    @Nullable
    public static PackageInfo getPackageInfo(String packageName, int flags) {
        PackageManager pm = ContextUtils.getApplicationContext().getPackageManager();
        try {
            return pm.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static int getPackageVersion(String packageName) {
        PackageInfo packageInfo = PackageUtils.getPackageInfo(packageName, 0);
        if (packageInfo != null) {
            return packageInfo.versionCode;
        }
        return -1;
    }

    public static int getPackageVersion(Context unused, String packageName) {
        return PackageUtils.getPackageVersion(packageName);
    }

    public static boolean isPackageInstalled(String packageName) {
        return PackageUtils.getPackageInfo(packageName, 0) != null;
    }

    public static PackageInfo getApplicationPackageInfo(int flags) {
        PackageInfo ret = PackageUtils.getPackageInfo(BuildInfo.getInstance().packageName, flags);
        assert (ret != null);
        return ret;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static List<String> getCertificateSHA256FingerprintForPackage(String packageName) {
        PackageInfo packageInfo = PackageUtils.getPackageInfo(packageName, 64);
        if (packageInfo == null) {
            return null;
        }
        ArrayList<String> fingerprints = new ArrayList<String>(packageInfo.signatures.length);
        for (Signature signature : packageInfo.signatures) {
            ByteArrayInputStream input = new ByteArrayInputStream(signature.toByteArray());
            String hexString = null;
            try {
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(input);
                hexString = PackageUtils.byteArrayToHexString(MessageDigest.getInstance("SHA256").digest(certificate.getEncoded()));
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                Log.w(TAG, "Exception", e);
                return null;
            }
            fingerprints.add(hexString);
        }
        return fingerprints;
    }

    @VisibleForTesting
    static String byteArrayToHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(byteArray.length * 3 - 1);
        for (int i = 0; i < byteArray.length; ++i) {
            hexString.append(HEX_CHAR_LOOKUP[(byteArray[i] & 0xF0) >>> 4]);
            hexString.append(HEX_CHAR_LOOKUP[byteArray[i] & 0xF]);
            if (i >= byteArray.length - 1) continue;
            hexString.append(':');
        }
        return hexString.toString();
    }

    private PackageUtils() {
    }
}

