/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.provider.MediaStore;
import android.system.Os;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.StrictModeContext;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.compat.ApiHelperForM;
import org.chromium.base.compat.ApiHelperForQ;
import org.chromium.base.compat.ApiHelperForR;
import org.chromium.base.task.AsyncTask;
import org.chromium.build.annotations.MainDex;

@MainDex
public abstract class PathUtils {
    private static final String TAG = "PathUtils";
    private static final String THUMBNAIL_DIRECTORY_NAME = "textures";
    private static final int DATA_DIRECTORY = 0;
    private static final int THUMBNAIL_DIRECTORY = 1;
    private static final int CACHE_DIRECTORY = 2;
    private static final int NUM_DIRECTORIES = 3;
    private static final AtomicBoolean sInitializationStarted = new AtomicBoolean();
    private static FutureTask<String[]> sDirPathFetchTask;
    private static String sDataDirectorySuffix;
    private static String sCacheSubDirectory;
    private static String sDataDirectoryBasePath;
    private static String sCacheDirectoryBasePath;

    private PathUtils() {
    }

    public static void resetForTesting() {
        sInitializationStarted.set(false);
        sDirPathFetchTask = null;
        sDataDirectorySuffix = null;
        sCacheSubDirectory = null;
        sDataDirectoryBasePath = null;
        sCacheDirectoryBasePath = null;
    }

    private static String[] getOrComputeDirectoryPaths() {
        if (!sDirPathFetchTask.isDone()) {
            try (StrictModeContext ignored = StrictModeContext.allowDiskWrites();){
                sDirPathFetchTask.run();
            }
        }
        try {
            return sDirPathFetchTask.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void chmod(String path, int mode) {
        try {
            Os.chmod((String)path, (int)mode);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to set permissions for path \"" + path + "\"");
        }
    }

    private static String[] setPrivateDirectoryPathInternal() {
        String[] paths = new String[3];
        File dataDir = null;
        File thumbnailDir = null;
        Context appContext = ContextUtils.getApplicationContext();
        if (sDataDirectoryBasePath == null) {
            dataDir = appContext.getDir(sDataDirectorySuffix, 0);
            thumbnailDir = appContext.getDir(THUMBNAIL_DIRECTORY_NAME, 0);
        } else {
            dataDir = new File(sDataDirectoryBasePath, sDataDirectorySuffix);
            dataDir.mkdirs();
            thumbnailDir = new File(sDataDirectoryBasePath, THUMBNAIL_DIRECTORY_NAME);
            thumbnailDir.mkdirs();
        }
        File cacheDir = null;
        cacheDir = sCacheDirectoryBasePath != null ? new File(sCacheDirectoryBasePath) : appContext.getCacheDir();
        if (cacheDir != null) {
            if (sCacheSubDirectory != null) {
                cacheDir = new File(cacheDir, sCacheSubDirectory);
            }
            if (sCacheDirectoryBasePath != null || sCacheSubDirectory != null) {
                cacheDir.mkdirs();
                PathUtils.chmod(cacheDir.getPath(), 1472);
            }
            paths[2] = cacheDir.getPath();
        }
        paths[0] = dataDir.getPath();
        PathUtils.chmod(paths[0], 448);
        paths[1] = thumbnailDir.getPath();
        return paths;
    }

    public static void setPrivateDirectoryPath(String dataBasePath, String cacheBasePath, String dataDirSuffix, String cacheSubDir) {
        if (!sInitializationStarted.getAndSet(true)) {
            assert (ContextUtils.getApplicationContext() != null);
            sDataDirectoryBasePath = dataBasePath;
            sCacheDirectoryBasePath = cacheBasePath;
            sDataDirectorySuffix = dataDirSuffix;
            sCacheSubDirectory = cacheSubDir;
            sDirPathFetchTask = new FutureTask<String[]>(PathUtils::setPrivateDirectoryPathInternal);
            AsyncTask.THREAD_POOL_EXECUTOR.execute(sDirPathFetchTask);
        } else {
            assert (TextUtils.equals((CharSequence)sDataDirectoryBasePath, (CharSequence)dataBasePath)) : String.format("%s != %s", dataBasePath, sDataDirectoryBasePath);
            assert (TextUtils.equals((CharSequence)sCacheDirectoryBasePath, (CharSequence)cacheBasePath)) : String.format("%s != %s", cacheBasePath, sCacheDirectoryBasePath);
            assert (TextUtils.equals((CharSequence)sDataDirectorySuffix, (CharSequence)dataDirSuffix)) : String.format("%s != %s", dataDirSuffix, sDataDirectorySuffix);
            assert (TextUtils.equals((CharSequence)sCacheSubDirectory, (CharSequence)cacheSubDir)) : String.format("%s != %s", cacheSubDir, sCacheSubDirectory);
        }
    }

    public static void setPrivateDataDirectorySuffix(String suffix, String cacheSubDir) {
        PathUtils.setPrivateDirectoryPath(null, null, suffix, cacheSubDir);
    }

    public static void setPrivateDataDirectorySuffix(String suffix) {
        PathUtils.setPrivateDataDirectorySuffix(suffix, null);
    }

    private static String getDirectoryPath(int index) {
        String[] paths = PathUtils.getOrComputeDirectoryPaths();
        return paths[index];
    }

    @CalledByNative
    public static String getDataDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(0);
    }

    @CalledByNative
    public static String getCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(2);
    }

    @CalledByNative
    public static String getThumbnailCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(1);
    }

    @CalledByNative
    @NonNull
    public static String getDownloadsDirectory() {
        try (StrictModeContext ignored = StrictModeContext.allowDiskReads();){
            if (Build.VERSION.SDK_INT >= 29) {
                String[] dirs = PathUtils.getAllPrivateDownloadsDirectories();
                assert (dirs != null);
                String string2 = dirs.length == 0 ? "" : dirs[0];
                return string2;
            }
            String string3 = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            return string3;
        }
    }

    @CalledByNative
    @NonNull
    public static String[] getAllPrivateDownloadsDirectories() {
        ArrayList<File> files = new ArrayList<File>();
        try (StrictModeContext ignored = StrictModeContext.allowDiskWrites();){
            File[] externalDirs = ContextUtils.getApplicationContext().getExternalFilesDirs(Environment.DIRECTORY_DOWNLOADS);
            files = externalDirs == null ? files : Arrays.asList(externalDirs);
        }
        return PathUtils.toAbsolutePathStrings(files);
    }

    @RequiresApi(value=30)
    @CalledByNative
    @NonNull
    public static String[] getExternalDownloadVolumesNames() {
        ArrayList<File> files = new ArrayList<File>();
        Set<String> volumes = ApiHelperForQ.getExternalVolumeNames(ContextUtils.getApplicationContext());
        for (String vol : volumes) {
            if (TextUtils.isEmpty((CharSequence)vol) || vol.contains("external_primary")) continue;
            StorageManager manager = ApiHelperForM.getSystemService(ContextUtils.getApplicationContext(), StorageManager.class);
            File volumeDir = ApiHelperForR.getVolumeDir(manager, MediaStore.Files.getContentUri((String)vol));
            File volumeDownloadDir = new File(volumeDir, Environment.DIRECTORY_DOWNLOADS);
            if (!volumeDownloadDir.isDirectory()) {
                Log.w(TAG, "Download dir missing: %s, parent dir:%s, isDirectory:%s", volumeDownloadDir.getAbsolutePath(), volumeDir.getAbsolutePath(), volumeDir.isDirectory());
            }
            files.add(volumeDownloadDir);
        }
        return PathUtils.toAbsolutePathStrings(files);
    }

    @NonNull
    private static String[] toAbsolutePathStrings(@NonNull List<File> files) {
        ArrayList<String> absolutePaths = new ArrayList<String>();
        for (File file : files) {
            if (file == null || TextUtils.isEmpty((CharSequence)file.getAbsolutePath())) continue;
            absolutePaths.add(file.getAbsolutePath());
        }
        return absolutePaths.toArray(new String[absolutePaths.size()]);
    }

    @CalledByNative
    private static String getNativeLibraryDirectory() {
        ApplicationInfo ai = ContextUtils.getApplicationContext().getApplicationInfo();
        if ((ai.flags & 0x80) != 0 || (ai.flags & 1) == 0) {
            return ai.nativeLibraryDir;
        }
        return "/system/lib/";
    }

    @CalledByNative
    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }
}

