/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import androidx.annotation.NonNull;
import org.chromium.base.Callback;
import org.chromium.base.LifetimeAssert;

public class RequiredCallback<T>
implements Callback<T> {
    private final LifetimeAssert mLifetimeAssert = LifetimeAssert.create(this);
    private Callback<T> mCallback;

    public RequiredCallback(@NonNull Callback<T> callback) {
        this.mCallback = callback;
    }

    @Override
    public void onResult(T result) {
        assert (this.mCallback != null) : "Callback was already called.";
        this.mCallback.onResult(result);
        LifetimeAssert.setSafeToGc(this.mLifetimeAssert, true);
        this.mCallback = null;
    }
}

