/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.chromium.build.BuildConfig;

public class ResettersForTesting {
    private static final LinkedHashSet<Runnable> sClassResetters = BuildConfig.IS_FOR_TEST ? new LinkedHashSet() : null;
    private static final LinkedHashSet<Runnable> sMethodResetters = BuildConfig.IS_FOR_TEST ? new LinkedHashSet() : null;
    private static boolean sMethodMode;

    public static void register(Runnable runnable) {
        if (!BuildConfig.IS_FOR_TEST) {
            return;
        }
        if (sMethodMode) {
            sMethodResetters.add(runnable);
        } else {
            sClassResetters.add(runnable);
        }
    }

    private static void flushResetters(LinkedHashSet activeSet) {
        ArrayList resetters = new ArrayList(activeSet);
        activeSet.clear();
        Collections.reverse(resetters);
        for (Runnable resetter : resetters) {
            resetter.run();
        }
    }

    public static void onAfterMethod() {
        ResettersForTesting.flushResetters(sMethodResetters);
    }

    public static void onAfterClass() {
        ResettersForTesting.flushResetters(sClassResetters);
        sMethodMode = false;
    }

    public static void setMethodMode() {
        sMethodMode = true;
    }
}

