/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Build;
import android.os.StrictMode;
import java.io.Closeable;
import org.chromium.base.TraceEvent;

public final class StrictModeContext
implements Closeable {
    private final StrictMode.ThreadPolicy mThreadPolicy;
    private final StrictMode.VmPolicy mVmPolicy;

    private StrictModeContext(StrictMode.ThreadPolicy threadPolicy, StrictMode.VmPolicy vmPolicy) {
        TraceEvent.startAsync("StrictModeContext", this.hashCode());
        this.mThreadPolicy = threadPolicy;
        this.mVmPolicy = vmPolicy;
    }

    private StrictModeContext(StrictMode.ThreadPolicy threadPolicy) {
        this(threadPolicy, null);
    }

    private StrictModeContext(StrictMode.VmPolicy vmPolicy) {
        this(null, vmPolicy);
    }

    public static StrictModeContext allowAllVmPolicies() {
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowAllVmPolicies");){
            StrictMode.VmPolicy oldPolicy = StrictMode.getVmPolicy();
            StrictMode.setVmPolicy((StrictMode.VmPolicy)StrictMode.VmPolicy.LAX);
            StrictModeContext strictModeContext = new StrictModeContext(oldPolicy);
            return strictModeContext;
        }
    }

    public static StrictModeContext allowAllThreadPolicies() {
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowAllThreadPolicies");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)StrictMode.ThreadPolicy.LAX);
            StrictModeContext strictModeContext = new StrictModeContext(oldPolicy);
            return strictModeContext;
        }
    }

    public static StrictModeContext allowDiskWrites() {
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowDiskWrites");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
            StrictModeContext strictModeContext = new StrictModeContext(oldPolicy);
            return strictModeContext;
        }
    }

    public static StrictModeContext allowDiskReads() {
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowDiskReads");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            StrictModeContext strictModeContext = new StrictModeContext(oldPolicy);
            return strictModeContext;
        }
    }

    public static StrictModeContext allowSlowCalls() {
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowSlowCalls");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(oldPolicy).permitCustomSlowCalls().build());
            StrictModeContext strictModeContext = new StrictModeContext(oldPolicy);
            return strictModeContext;
        }
    }

    public static StrictModeContext allowUnbufferedIo() {
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowUnbufferedIo");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
            if (Build.VERSION.SDK_INT >= 26) {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(oldPolicy).permitUnbufferedIo().build());
            }
            StrictModeContext strictModeContext = new StrictModeContext(oldPolicy);
            return strictModeContext;
        }
    }

    @Override
    public void close() {
        if (this.mThreadPolicy != null) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)this.mThreadPolicy);
        }
        if (this.mVmPolicy != null) {
            StrictMode.setVmPolicy((StrictMode.VmPolicy)this.mVmPolicy);
        }
        TraceEvent.finishAsync("StrictModeContext", this.hashCode());
    }
}

