/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.chromium.base.ResettersForTesting;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.task.PostTask;

public class ThreadUtils {
    private static final Object sLock = new Object();
    private static volatile boolean sWillOverride;
    private static volatile Handler sUiThreadHandler;
    private static boolean sThreadAssertsDisabledForTesting;

    public static void setWillOverrideUiThread() {
        sWillOverride = true;
        assert (sUiThreadHandler == null);
    }

    public static void clearUiThreadForTesting() {
        sWillOverride = false;
        PostTask.resetUiThreadForTesting();
        sUiThreadHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUiThread(Looper looper) {
        assert (looper != null);
        Object object = sLock;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                Handler uiThreadHandler = new Handler(looper);
                PostTask.onUiThreadReady(uiThreadHandler);
                sUiThreadHandler = uiThreadHandler;
                TraceEvent.onUiThreadReady();
            } else if (sUiThreadHandler.getLooper() != looper) {
                throw new RuntimeException("UI thread looper is already set to " + sUiThreadHandler.getLooper() + " (Main thread looper is " + Looper.getMainLooper() + "), cannot set to new looper " + looper);
            }
        }
    }

    public static Handler getUiThreadHandler() {
        if (sUiThreadHandler != null) {
            return sUiThreadHandler;
        }
        if (sWillOverride) {
            throw new RuntimeException("Did not yet override the UI thread");
        }
        ThreadUtils.setUiThread(Looper.getMainLooper());
        return sUiThreadHandler;
    }

    public static void runOnUiThreadBlocking(Runnable r) {
        PostTask.runSynchronously(7, r);
    }

    public static <T> T runOnUiThreadBlockingNoException(Callable<T> c) {
        try {
            return ThreadUtils.runOnUiThreadBlocking(c);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error occurred waiting for callable", e);
        }
    }

    public static <T> T runOnUiThreadBlocking(Callable<T> c) throws ExecutionException {
        return PostTask.runSynchronously(7, c);
    }

    public static <T> FutureTask<T> runOnUiThread(FutureTask<T> task) {
        PostTask.runOrPostTask(7, task);
        return task;
    }

    public static <T> FutureTask<T> runOnUiThread(Callable<T> c) {
        return ThreadUtils.runOnUiThread(new FutureTask<T>(c));
    }

    public static void runOnUiThread(Runnable r) {
        PostTask.runOrPostTask(7, r);
    }

    public static <T> FutureTask<T> postOnUiThread(FutureTask<T> task) {
        PostTask.postTask(7, task);
        return task;
    }

    public static void postOnUiThread(Runnable r) {
        PostTask.postTask(7, r);
    }

    public static void postOnUiThreadDelayed(Runnable r, long delayMillis) {
        PostTask.postDelayedTask(7, r, delayMillis);
    }

    public static void assertOnUiThread() {
        if (sThreadAssertsDisabledForTesting) {
            return;
        }
        assert (ThreadUtils.runningOnUiThread()) : "Must be called on the UI thread.";
    }

    public static void checkUiThread() {
        if (!sThreadAssertsDisabledForTesting && !ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Must be called on the UI thread.");
        }
    }

    public static void assertOnBackgroundThread() {
        if (sThreadAssertsDisabledForTesting) {
            return;
        }
        assert (!ThreadUtils.runningOnUiThread()) : "Must be called on a thread other than UI.";
    }

    public static void setThreadAssertsDisabledForTesting(boolean disabled) {
        sThreadAssertsDisabledForTesting = disabled;
        ResettersForTesting.register(() -> {
            sThreadAssertsDisabledForTesting = false;
        });
    }

    public static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static Looper getUiThreadLooper() {
        return ThreadUtils.getUiThreadHandler().getLooper();
    }

    @CalledByNative
    public static void setThreadPriorityAudio(int tid) {
        Process.setThreadPriority((int)tid, (int)-16);
    }

    @CalledByNative
    private static boolean isThreadPriorityAudio(int tid) {
        return Process.getThreadPriority((int)tid) == -16;
    }

    public static class ThreadChecker {
        private final long mThreadId = Process.myTid();

        public void assertOnValidThread() {
            assert (sThreadAssertsDisabledForTesting || this.mThreadId == (long)Process.myTid()) : "Must only be used on a single thread.";
        }
    }
}

