/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.SystemClock;
import org.chromium.build.annotations.CheckDiscard;

public class TimeUtils {
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long NANOSECONDS_PER_MICROSECOND = 1000L;
    public static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    static FakeClock sFakeClock;

    private TimeUtils() {
    }

    @CheckDiscard(value="Should get inlined by R8.")
    public static long currentTimeMillis() {
        if (sFakeClock != null) {
            return sFakeClock.currentTimeMillis();
        }
        return System.currentTimeMillis();
    }

    @CheckDiscard(value="Should get inlined by R8.")
    public static long uptimeMillis() {
        if (sFakeClock != null) {
            return sFakeClock.uptimeMillis();
        }
        return SystemClock.uptimeMillis();
    }

    @CheckDiscard(value="Should get inlined by R8.")
    public static long elapsedRealtimeNanos() {
        if (sFakeClock != null) {
            return sFakeClock.elapsedRealtimeNanos();
        }
        return SystemClock.elapsedRealtimeNanos();
    }

    @CheckDiscard(value="Should get inlined by R8.")
    public static long elapsedRealtimeMillis() {
        if (sFakeClock != null) {
            return sFakeClock.elapsedRealtimeNanos() / 1000000L;
        }
        return SystemClock.elapsedRealtime();
    }

    @CheckDiscard(value="Should get inlined by R8.")
    public static long currentThreadTimeMillis() {
        if (sFakeClock != null) {
            return sFakeClock.currentThreadTimeMillis();
        }
        return SystemClock.currentThreadTimeMillis();
    }

    static interface FakeClock {
        public long uptimeMillis();

        public long elapsedRealtimeNanos();

        public long currentThreadTimeMillis();

        public long currentTimeMillis();
    }

    @CheckDiscard(value="Class should get inlined by R8.")
    public static class CurrentThreadTimeMillisTimer {
        private final long mStart = TimeUtils.currentThreadTimeMillis();

        public long getElapsedMillis() {
            return TimeUtils.currentThreadTimeMillis() - this.mStart;
        }
    }

    @CheckDiscard(value="Class should get inlined by R8.")
    public static class ElapsedRealtimeNanosTimer {
        private final long mStart = TimeUtils.elapsedRealtimeNanos();

        public long getElapsedNanos() {
            return TimeUtils.elapsedRealtimeNanos() - this.mStart;
        }
    }

    @CheckDiscard(value="Class should get inlined by R8.")
    public static class ElapsedRealtimeMillisTimer {
        private final long mStart = TimeUtils.elapsedRealtimeMillis();

        public long getElapsedMillis() {
            return TimeUtils.elapsedRealtimeMillis() - this.mStart;
        }
    }

    @CheckDiscard(value="Class should get inlined by R8.")
    public static class UptimeMillisTimer {
        private final long mStart = TimeUtils.uptimeMillis();

        public long getElapsedMillis() {
            return TimeUtils.uptimeMillis() - this.mStart;
        }
    }
}

