/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import org.chromium.base.ThreadUtils;
import org.chromium.base.UnownedUserData;
import org.chromium.base.UnownedUserDataKey;
import org.chromium.base.lifetime.DestroyChecker;

public final class UnownedUserDataHost {
    private final ThreadUtils.ThreadChecker mThreadChecker = new ThreadUtils.ThreadChecker();
    private final DestroyChecker mDestroyChecker = new DestroyChecker();
    private Handler mHandler;
    private HashMap<UnownedUserDataKey<?>, WeakReference<? extends UnownedUserData>> mUnownedUserDataMap = new HashMap();

    private static Looper retrieveNonNullLooperOrThrow() {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            throw new IllegalStateException();
        }
        return looper;
    }

    public UnownedUserDataHost() {
        this(new Handler(UnownedUserDataHost.retrieveNonNullLooperOrThrow()));
    }

    @VisibleForTesting(otherwise=2)
    UnownedUserDataHost(Handler handler) {
        this.mHandler = handler;
    }

    <T extends UnownedUserData> void set(@NonNull UnownedUserDataKey<T> key, @NonNull T newValue) {
        T currentValue;
        this.checkState();
        if (this.mUnownedUserDataMap.containsKey(key) && !newValue.equals(currentValue = this.get(key))) {
            key.detachFromHost(this);
        }
        this.mUnownedUserDataMap.put(key, new WeakReference<T>(newValue));
    }

    @Nullable
    <T extends UnownedUserData> T get(@NonNull UnownedUserDataKey<T> key) {
        this.checkState();
        WeakReference<? extends UnownedUserData> valueWeakRef = this.mUnownedUserDataMap.get(key);
        if (valueWeakRef == null) {
            return null;
        }
        UnownedUserData value = (UnownedUserData)valueWeakRef.get();
        if (value == null) {
            key.detachFromHost(this);
            return null;
        }
        return (T)((UnownedUserData)key.getValueClass().cast(value));
    }

    <T extends UnownedUserData> void remove(@NonNull UnownedUserDataKey<T> key) {
        this.checkState();
        WeakReference<? extends UnownedUserData> valueWeakRef = this.mUnownedUserDataMap.remove(key);
        if (valueWeakRef == null) {
            return;
        }
        UnownedUserData value = (UnownedUserData)valueWeakRef.get();
        if (value != null && value.informOnDetachmentFromHost()) {
            this.mHandler.post(() -> value.onDetachedFromHost(this));
        }
    }

    public void destroy() {
        this.mThreadChecker.assertOnValidThread();
        if (this.mDestroyChecker.isDestroyed()) {
            return;
        }
        HashSet keys = new HashSet(this.mUnownedUserDataMap.keySet());
        for (UnownedUserDataKey unownedUserDataKey : keys) {
            unownedUserDataKey.detachFromHost(this);
        }
        this.mUnownedUserDataMap = null;
        this.mHandler = null;
        this.mDestroyChecker.destroy();
    }

    @VisibleForTesting(otherwise=5)
    int getMapSize() {
        this.checkState();
        return this.mUnownedUserDataMap.size();
    }

    boolean isDestroyed() {
        return this.mDestroyChecker.isDestroyed();
    }

    private void checkState() {
        this.mThreadChecker.assertOnValidThread();
        this.mDestroyChecker.checkNotDestroyed();
    }
}

