/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.memory;

import android.app.ActivityManager;
import android.os.Debug;
import android.os.Process;
import androidx.annotation.Nullable;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.CalledByNative;

public class MemoryInfoBridge {
    @CalledByNative
    @Nullable
    public static Debug.MemoryInfo getActivityManagerMemoryInfoForSelf() {
        ActivityManager activityManager = (ActivityManager)ContextUtils.getApplicationContext().getSystemService("activity");
        int pid = Process.myPid();
        try {
            Debug.MemoryInfo[] infos = activityManager.getProcessMemoryInfo(new int[]{pid});
            return infos == null ? null : infos[0];
        }
        catch (SecurityException e) {
            return null;
        }
    }
}

