/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Callback;
import org.chromium.base.Log;
import org.chromium.base.metrics.HistogramBucket;
import org.chromium.base.metrics.UmaRecorder;
import org.chromium.build.BuildConfig;

final class CachingUmaRecorder
implements UmaRecorder {
    private static final String TAG = "CachingUmaRecorder";
    private static final int MAX_HISTOGRAM_COUNT = 256;
    @VisibleForTesting
    static final int MAX_USER_ACTION_COUNT = 256;
    private final ReentrantReadWriteLock mRwLock = new ReentrantReadWriteLock(false);
    @GuardedBy(value="mRwLock")
    private Map<String, Histogram> mHistogramByName = new HashMap<String, Histogram>();
    private AtomicInteger mDroppedHistogramSampleCount = new AtomicInteger();
    @GuardedBy(value="mRwLock")
    private List<UserAction> mUserActions = new ArrayList<UserAction>();
    @GuardedBy(value="mRwLock")
    private int mDroppedUserActionCount;
    @GuardedBy(value="mRwLock")
    @Nullable
    private UmaRecorder mDelegate;
    @GuardedBy(value="mRwLock")
    @Nullable
    private List<Callback<String>> mUserActionCallbacksForTesting;

    CachingUmaRecorder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UmaRecorder setDelegate(@Nullable UmaRecorder recorder) {
        UmaRecorder previous;
        Map<String, Histogram> histogramCache = null;
        int droppedHistogramSampleCount = 0;
        List<UserAction> userActionCache = null;
        int droppedUserActionCount = 0;
        this.mRwLock.writeLock().lock();
        try {
            previous = this.mDelegate;
            this.mDelegate = recorder;
            if (BuildConfig.IS_FOR_TEST) {
                this.swapUserActionCallbacksForTesting(previous, recorder);
            }
            if (recorder == null) {
                UmaRecorder umaRecorder = previous;
                return umaRecorder;
            }
            if (!this.mHistogramByName.isEmpty()) {
                histogramCache = this.mHistogramByName;
                this.mHistogramByName = new HashMap<String, Histogram>();
                droppedHistogramSampleCount = this.mDroppedHistogramSampleCount.getAndSet(0);
            }
            if (!this.mUserActions.isEmpty()) {
                userActionCache = this.mUserActions;
                this.mUserActions = new ArrayList<UserAction>();
                droppedUserActionCount = this.mDroppedUserActionCount;
                this.mDroppedUserActionCount = 0;
            }
            this.mRwLock.readLock().lock();
        }
        finally {
            this.mRwLock.writeLock().unlock();
        }
        try {
            if (histogramCache != null) {
                this.flushHistogramsAlreadyLocked(histogramCache, droppedHistogramSampleCount);
            }
            if (userActionCache != null) {
                this.flushUserActionsAlreadyLocked(userActionCache, droppedUserActionCount);
            }
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
        return previous;
    }

    @GuardedBy(value="mRwLock")
    private void flushHistogramsAlreadyLocked(Map<String, Histogram> cache, int droppedHistogramSampleCount) {
        assert (this.mDelegate != null) : "Unexpected: cache is flushed, but delegate is null";
        assert (this.mRwLock.getReadHoldCount() > 0);
        int flushedHistogramSampleCount = 0;
        int flushedHistogramCount = cache.size();
        for (Histogram histogram : cache.values()) {
            flushedHistogramSampleCount += histogram.flushTo(this.mDelegate);
        }
        Log.i(TAG, "Flushed %d samples from %d histograms, %d samples were dropped.", flushedHistogramSampleCount, flushedHistogramCount, droppedHistogramSampleCount);
    }

    private void flushUserActionsAlreadyLocked(List<UserAction> cache, int droppedUserActionCount) {
        assert (this.mDelegate != null) : "Unexpected: cache is flushed, but delegate is null";
        assert (this.mRwLock.getReadHoldCount() > 0);
        for (UserAction userAction : cache) {
            userAction.flushTo(this.mDelegate);
        }
        Log.i(TAG, "Flushed %d user action samples, %d samples were dropped.", (Object)cache.size(), (Object)droppedUserActionCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheOrRecordHistogramSample(int type, String name, int sample, int min, int max, int numBuckets) {
        if (this.tryAppendOrRecordSample(type, name, sample, min, max, numBuckets)) {
            return;
        }
        this.mRwLock.writeLock().lock();
        try {
            if (this.mDelegate == null) {
                this.cacheHistogramSampleAlreadyWriteLocked(type, name, sample, min, max, numBuckets);
                return;
            }
            this.mRwLock.readLock().lock();
        }
        finally {
            this.mRwLock.writeLock().unlock();
        }
        try {
            assert (this.mDelegate != null);
            this.recordHistogramSampleAlreadyLocked(type, name, sample, min, max, numBuckets);
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAppendOrRecordSample(int type, String name, int sample, int min, int max, int numBuckets) {
        this.mRwLock.readLock().lock();
        try {
            if (this.mDelegate != null) {
                this.recordHistogramSampleAlreadyLocked(type, name, sample, min, max, numBuckets);
                boolean bl = true;
                return bl;
            }
            Histogram histogram = this.mHistogramByName.get(name);
            if (histogram == null) {
                boolean bl = false;
                return bl;
            }
            if (!histogram.addSample(type, name, sample, min, max, numBuckets)) {
                this.mDroppedHistogramSampleCount.incrementAndGet();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
    }

    @GuardedBy(value="mRwLock")
    private void cacheHistogramSampleAlreadyWriteLocked(int type, String name, int sample, int min, int max, int numBuckets) {
        assert (this.mRwLock.isWriteLockedByCurrentThread());
        Histogram histogram = this.mHistogramByName.get(name);
        if (histogram == null) {
            if (this.mHistogramByName.size() >= 256) {
                assert (false) : "Too many histograms in cache";
                this.mDroppedHistogramSampleCount.incrementAndGet();
                return;
            }
            histogram = new Histogram(type, name, min, max, numBuckets);
            this.mHistogramByName.put(name, histogram);
        }
        if (!histogram.addSample(type, name, sample, min, max, numBuckets)) {
            this.mDroppedHistogramSampleCount.incrementAndGet();
        }
    }

    @GuardedBy(value="mRwLock")
    private void recordHistogramSampleAlreadyLocked(int type, String name, int sample, int min, int max, int numBuckets) {
        assert (this.mRwLock.getReadHoldCount() > 0);
        assert (!this.mRwLock.isWriteLockedByCurrentThread());
        assert (this.mDelegate != null) : "recordSampleAlreadyLocked called with no delegate to record to";
        switch (type) {
            case 1: {
                this.mDelegate.recordBooleanHistogram(name, sample != 0);
                break;
            }
            case 2: {
                this.mDelegate.recordExponentialHistogram(name, sample, min, max, numBuckets);
                break;
            }
            case 3: {
                this.mDelegate.recordLinearHistogram(name, sample, min, max, numBuckets);
                break;
            }
            case 4: {
                this.mDelegate.recordSparseHistogram(name, sample);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown histogram type " + type);
            }
        }
    }

    @Override
    public void recordBooleanHistogram(String name, boolean boolSample) {
        int sample = boolSample ? 1 : 0;
        boolean min = false;
        boolean max = false;
        boolean numBuckets = false;
        this.cacheOrRecordHistogramSample(1, name, sample, 0, 0, 0);
    }

    @Override
    public void recordExponentialHistogram(String name, int sample, int min, int max, int numBuckets) {
        this.cacheOrRecordHistogramSample(2, name, sample, min, max, numBuckets);
    }

    @Override
    public void recordLinearHistogram(String name, int sample, int min, int max, int numBuckets) {
        this.cacheOrRecordHistogramSample(3, name, sample, min, max, numBuckets);
    }

    @Override
    public void recordSparseHistogram(String name, int sample) {
        boolean min = false;
        boolean max = false;
        boolean numBuckets = false;
        this.cacheOrRecordHistogramSample(4, name, sample, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordUserAction(String name, long elapsedRealtimeMillis) {
        this.mRwLock.readLock().lock();
        try {
            if (this.mDelegate != null) {
                this.mDelegate.recordUserAction(name, elapsedRealtimeMillis);
                return;
            }
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
        this.mRwLock.writeLock().lock();
        try {
            if (this.mDelegate == null) {
                if (this.mUserActions.size() < 256) {
                    this.mUserActions.add(new UserAction(name, elapsedRealtimeMillis));
                } else {
                    assert (false) : "Too many user actions in cache";
                    ++this.mDroppedUserActionCount;
                }
                if (this.mUserActionCallbacksForTesting != null) {
                    for (int i = 0; i < this.mUserActionCallbacksForTesting.size(); ++i) {
                        this.mUserActionCallbacksForTesting.get(i).onResult(name);
                    }
                }
                return;
            }
            this.mRwLock.readLock().lock();
        }
        finally {
            this.mRwLock.writeLock().unlock();
        }
        try {
            assert (this.mDelegate != null);
            this.mDelegate.recordUserAction(name, elapsedRealtimeMillis);
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int getHistogramValueCountForTesting(String name, int sample) {
        this.mRwLock.readLock().lock();
        try {
            if (this.mDelegate != null) {
                int n = this.mDelegate.getHistogramValueCountForTesting(name, sample);
                return n;
            }
            Histogram histogram = this.mHistogramByName.get(name);
            if (histogram == null) {
                int n = 0;
                return n;
            }
            int sampleCount = 0;
            Histogram histogram2 = histogram;
            synchronized (histogram2) {
                for (int i = 0; i < histogram.mSamples.size(); ++i) {
                    if (histogram.mSamples.get(i) != sample) continue;
                    ++sampleCount;
                }
            }
            int n = sampleCount;
            return n;
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int getHistogramTotalCountForTesting(String name) {
        this.mRwLock.readLock().lock();
        try {
            if (this.mDelegate != null) {
                int n = this.mDelegate.getHistogramTotalCountForTesting(name);
                return n;
            }
            Histogram histogram = this.mHistogramByName.get(name);
            if (histogram == null) {
                int n = 0;
                return n;
            }
            Histogram histogram2 = histogram;
            synchronized (histogram2) {
                int n = histogram.mSamples.size();
                return n;
            }
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public List<HistogramBucket> getHistogramSamplesForTesting(String name) {
        this.mRwLock.readLock().lock();
        try {
            Object[] samplesCopy;
            if (this.mDelegate != null) {
                List<HistogramBucket> list = this.mDelegate.getHistogramSamplesForTesting(name);
                return list;
            }
            Histogram histogram = this.mHistogramByName.get(name);
            if (histogram == null) {
                List<HistogramBucket> list = Collections.emptyList();
                return list;
            }
            Histogram histogram2 = histogram;
            synchronized (histogram2) {
                samplesCopy = histogram.mSamples.toArray(new Integer[0]);
            }
            Arrays.sort(samplesCopy);
            ArrayList<HistogramBucket> buckets = new ArrayList<HistogramBucket>();
            int i = 0;
            while (i < samplesCopy.length) {
                int value = (Integer)samplesCopy[i];
                int countInBucket = 0;
                do {
                    ++countInBucket;
                } while (++i < samplesCopy.length && (Integer)samplesCopy[i] == value);
                buckets.add(new HistogramBucket(value, value + 1, countInBucket));
            }
            ArrayList<HistogramBucket> arrayList = buckets;
            return arrayList;
        }
        finally {
            this.mRwLock.readLock().unlock();
        }
    }

    @Override
    @VisibleForTesting
    public void addUserActionCallbackForTesting(Callback<String> callback) {
        this.mRwLock.writeLock().lock();
        try {
            if (this.mUserActionCallbacksForTesting == null) {
                this.mUserActionCallbacksForTesting = new ArrayList<Callback<String>>();
            }
            this.mUserActionCallbacksForTesting.add(callback);
            if (this.mDelegate != null) {
                this.mDelegate.addUserActionCallbackForTesting(callback);
            }
        }
        finally {
            this.mRwLock.writeLock().unlock();
        }
    }

    @Override
    @VisibleForTesting
    public void removeUserActionCallbackForTesting(Callback<String> callback) {
        this.mRwLock.writeLock().lock();
        try {
            if (this.mUserActionCallbacksForTesting == null) {
                assert (false) : "Attempting to remove a user action callback without previously registering any.";
                return;
            }
            this.mUserActionCallbacksForTesting.remove(callback);
            if (this.mDelegate != null) {
                this.mDelegate.removeUserActionCallbackForTesting(callback);
            }
        }
        finally {
            this.mRwLock.writeLock().unlock();
        }
    }

    @SuppressLint(value={"VisibleForTests"})
    @GuardedBy(value="mRwLock")
    private void swapUserActionCallbacksForTesting(@Nullable UmaRecorder previousRecorder, @Nullable UmaRecorder newRecorder) {
        if (this.mUserActionCallbacksForTesting == null) {
            return;
        }
        for (int i = 0; i < this.mUserActionCallbacksForTesting.size(); ++i) {
            if (previousRecorder != null) {
                previousRecorder.removeUserActionCallbackForTesting(this.mUserActionCallbacksForTesting.get(i));
            }
            if (newRecorder == null) continue;
            newRecorder.addUserActionCallbackForTesting(this.mUserActionCallbacksForTesting.get(i));
        }
    }

    @VisibleForTesting
    static class Histogram {
        @VisibleForTesting
        static final int MAX_SAMPLE_COUNT = 256;
        private final int mType;
        private final String mName;
        private final int mMin;
        private final int mMax;
        private final int mNumBuckets;
        @GuardedBy(value="this")
        private final List<Integer> mSamples;

        Histogram(int type, String name, int min, int max, int numBuckets) {
            assert (type == 2 || type == 3 || min == 0 && max == 0 && numBuckets == 0) : "Histogram type " + type + " must have no min/max/buckets set";
            this.mType = type;
            this.mName = name;
            this.mMin = min;
            this.mMax = max;
            this.mNumBuckets = numBuckets;
            this.mSamples = new ArrayList<Integer>(1);
        }

        synchronized boolean addSample(int type, String name, int sample, int min, int max, int numBuckets) {
            assert (this.mType == type);
            assert (this.mName.equals(name));
            assert (this.mMin == min);
            assert (this.mMax == max);
            assert (this.mNumBuckets == numBuckets);
            if (this.mSamples.size() >= 256) {
                assert (false) : "Histogram exceeded sample cache size limit";
                return false;
            }
            this.mSamples.add(sample);
            return true;
        }

        synchronized int flushTo(UmaRecorder recorder) {
            switch (this.mType) {
                case 1: {
                    int i;
                    for (i = 0; i < this.mSamples.size(); ++i) {
                        int sample = this.mSamples.get(i);
                        recorder.recordBooleanHistogram(this.mName, sample != 0);
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < this.mSamples.size(); ++i) {
                        int sample = this.mSamples.get(i);
                        recorder.recordExponentialHistogram(this.mName, sample, this.mMin, this.mMax, this.mNumBuckets);
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < this.mSamples.size(); ++i) {
                        int sample = this.mSamples.get(i);
                        recorder.recordLinearHistogram(this.mName, sample, this.mMin, this.mMax, this.mNumBuckets);
                    }
                    break;
                }
                case 4: {
                    int i;
                    for (i = 0; i < this.mSamples.size(); ++i) {
                        int sample = this.mSamples.get(i);
                        recorder.recordSparseHistogram(this.mName, sample);
                    }
                    break;
                }
                default: {
                    assert (false) : "Unknown histogram type " + this.mType;
                    break;
                }
            }
            int count = this.mSamples.size();
            this.mSamples.clear();
            return count;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface Type {
            public static final int BOOLEAN = 1;
            public static final int EXPONENTIAL = 2;
            public static final int LINEAR = 3;
            public static final int SPARSE = 4;
        }
    }

    private static class UserAction {
        private final String mName;
        private final long mElapsedRealtimeMillis;

        UserAction(String name, long elapsedRealtimeMillis) {
            this.mName = name;
            this.mElapsedRealtimeMillis = elapsedRealtimeMillis;
        }

        void flushTo(UmaRecorder recorder) {
            recorder.recordUserAction(this.mName, this.mElapsedRealtimeMillis);
        }
    }
}

