/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.supplier;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.chromium.base.Callback;
import org.chromium.base.Promise;
import org.chromium.base.ThreadUtils;
import org.chromium.base.supplier.OneshotSupplier;

public abstract class LazyOneshotSupplier<T>
implements OneshotSupplier<T> {
    private final Promise<T> mPromise = new Promise();
    private final ThreadUtils.ThreadChecker mThreadChecker = new ThreadUtils.ThreadChecker();

    @Override
    public T onAvailable(Callback<T> callback) {
        this.mThreadChecker.assertOnValidThread();
        this.mPromise.then(callback);
        return this.hasValue() ? (T)this.get() : null;
    }

    @Override
    @Nullable
    public T get() {
        this.mThreadChecker.assertOnValidThread();
        if (!this.hasValue()) {
            this.doSet();
        }
        return this.hasValue() ? (T)this.mPromise.getResult() : null;
    }

    @Override
    public boolean hasValue() {
        return this.mPromise.isFulfilled();
    }

    public abstract void doSet();

    public void set(@NonNull T object) {
        this.mThreadChecker.assertOnValidThread();
        assert (!this.mPromise.isFulfilled());
        assert (object != null);
        this.mPromise.fulfill(object);
    }
}

