/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.supplier;

import android.os.Handler;
import androidx.annotation.Nullable;
import org.chromium.base.Callback;
import org.chromium.base.ObserverList;
import org.chromium.base.ResettersForTesting;
import org.chromium.base.supplier.ObservableSupplier;

public class ObservableSupplierImpl<E>
implements ObservableSupplier<E> {
    private static boolean sIgnoreThreadChecksForTesting;
    private final Thread mThread = Thread.currentThread();
    private final Handler mHandler = new Handler();
    private E mObject;
    private final ObserverList<Callback<E>> mObservers = new ObserverList();

    public ObservableSupplierImpl() {
    }

    public ObservableSupplierImpl(E initialValue) {
        this.mObject = initialValue;
    }

    @Override
    public E addObserver(Callback<E> obs) {
        this.checkThread();
        this.mObservers.addObserver(obs);
        if (this.mObject != null) {
            E currentObject = this.mObject;
            this.mHandler.post(() -> {
                if (this.mObject != currentObject || !this.mObservers.hasObserver(obs)) {
                    return;
                }
                obs.onResult(this.mObject);
            });
        }
        return this.mObject;
    }

    @Override
    public void removeObserver(Callback<E> obs) {
        this.checkThread();
        this.mObservers.removeObserver(obs);
    }

    public void set(E object) {
        this.checkThread();
        if (object == this.mObject) {
            return;
        }
        this.mObject = object;
        for (Callback<E> observer : this.mObservers) {
            observer.onResult(this.mObject);
        }
    }

    @Override
    @Nullable
    public E get() {
        this.checkThread();
        return this.mObject;
    }

    private void checkThread() {
        assert (sIgnoreThreadChecksForTesting || this.mThread == Thread.currentThread()) : "ObservableSupplierImpl must only be used on a single Thread.";
    }

    public static void setIgnoreThreadChecksForTesting(boolean ignoreThreadChecks) {
        sIgnoreThreadChecksForTesting = ignoreThreadChecks;
        ResettersForTesting.register(() -> {
            sIgnoreThreadChecksForTesting = false;
        });
    }
}

