/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.supplier;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import org.chromium.base.UnownedUserData;
import org.chromium.base.UnownedUserDataHost;
import org.chromium.base.UnownedUserDataKey;
import org.chromium.base.lifetime.DestroyChecker;
import org.chromium.base.lifetime.Destroyable;
import org.chromium.base.supplier.ObservableSupplierImpl;

public abstract class UnownedUserDataSupplier<E>
extends ObservableSupplierImpl<E>
implements Destroyable,
UnownedUserData {
    private final UnownedUserDataKey<UnownedUserDataSupplier<E>> mUudKey;
    private final DestroyChecker mDestroyChecker = new DestroyChecker();

    protected UnownedUserDataSupplier(@NonNull UnownedUserDataKey<? extends UnownedUserDataSupplier<E>> uudKey) {
        this.mUudKey = uudKey;
    }

    public void attach(@NonNull UnownedUserDataHost host) {
        this.mDestroyChecker.checkNotDestroyed();
        this.mUudKey.attachToHost(host, this);
    }

    @Override
    @CallSuper
    public void destroy() {
        this.mDestroyChecker.destroy();
        this.mUudKey.detachFromAllHosts(this);
    }
}

