/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.util.Pair;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.TraceEvent;
import org.chromium.base.task.PostTask;

public class ChainedTasks {
    private final LinkedList<Pair<Integer, Runnable>> mTasks = new LinkedList();
    @GuardedBy(value="mTasks")
    private boolean mFinalized;
    private volatile boolean mCanceled;
    private int mIterationIdForTesting = PostTask.sTestIterationForTesting;
    private final Runnable mRunAndPost = new Runnable(){

        @Override
        public void run() {
            if (ChainedTasks.this.mIterationIdForTesting != PostTask.sTestIterationForTesting) {
                ChainedTasks.this.cancel();
            }
            if (ChainedTasks.this.mCanceled) {
                return;
            }
            Pair<Integer, Runnable> pair = ChainedTasks.this.mTasks.pop();
            try (TraceEvent e = TraceEvent.scoped("ChainedTask.run: " + ((Runnable)pair.second).getClass().getName());){
                ((Runnable)pair.second).run();
            }
            if (!ChainedTasks.this.mTasks.isEmpty()) {
                PostTask.postTask((Integer)ChainedTasks.this.mTasks.peek().first, this);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int traits, Runnable task) {
        assert (this.mIterationIdForTesting == PostTask.sTestIterationForTesting);
        LinkedList<Pair<Integer, Runnable>> linkedList = this.mTasks;
        synchronized (linkedList) {
            assert (!this.mFinalized) : "Must not call add() after start()";
            this.mTasks.add((Pair<Integer, Runnable>)new Pair((Object)traits, (Object)task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LinkedList<Pair<Integer, Runnable>> linkedList = this.mTasks;
        synchronized (linkedList) {
            this.mFinalized = true;
            this.mCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean coalesceTasks) {
        LinkedList<Pair<Integer, Runnable>> linkedList = this.mTasks;
        synchronized (linkedList) {
            assert (!this.mFinalized) : "Cannot call start() several times";
            this.mFinalized = true;
        }
        if (this.mTasks.isEmpty()) {
            return;
        }
        if (coalesceTasks) {
            int traits = (Integer)this.mTasks.peek().first;
            PostTask.runOrPostTask(traits, () -> {
                for (Pair pair : this.mTasks) {
                    assert (PostTask.canRunTaskImmediately((Integer)pair.first));
                    ((Runnable)pair.second).run();
                    if (!this.mCanceled) continue;
                    return;
                }
            });
        } else {
            PostTask.postTask((Integer)this.mTasks.peek().first, this.mRunAndPost);
        }
    }
}

