/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.os.AsyncTask;
import androidx.annotation.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.chromium.base.task.AsyncTask;
import org.chromium.build.BuildConfig;

class ChromeThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE_SECONDS = 30;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "CrAsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new ArrayBlockingQueue<Runnable>(128);
    private static final int RUNNABLE_WARNING_COUNT = 32;

    ChromeThreadPoolExecutor() {
        this(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 30L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
    }

    @VisibleForTesting
    ChromeThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.allowCoreThreadTimeOut(true);
    }

    private static String getClassName(Runnable runnable) {
        Class<?> blamedClass;
        block7: {
            blamedClass = runnable.getClass();
            try {
                if (blamedClass == AsyncTask.NamedFutureTask.class) {
                    blamedClass = ((AsyncTask.NamedFutureTask)runnable).getBlamedClass();
                } else if (blamedClass.getEnclosingClass() == AsyncTask.class) {
                    Field field = blamedClass.getDeclaredField("this$0");
                    field.setAccessible(true);
                    blamedClass = field.get(runnable).getClass();
                }
            }
            catch (NoSuchFieldException e) {
                if (BuildConfig.ENABLE_ASSERTS) {
                    throw new RuntimeException(e);
                }
            }
            catch (IllegalAccessException e) {
                if (!BuildConfig.ENABLE_ASSERTS) break block7;
                throw new RuntimeException(e);
            }
        }
        return blamedClass.getName();
    }

    private Map<String, Integer> getNumberOfClassNameOccurrencesInQueue() {
        Runnable[] copiedQueue;
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Runnable runnable : copiedQueue = this.getQueue().toArray(new Runnable[0])) {
            String className = ChromeThreadPoolExecutor.getClassName(runnable);
            int count = counts.containsKey(className) ? (Integer)counts.get(className) : 0;
            counts.put(className, count + 1);
        }
        return counts;
    }

    private String findClassNamesWithTooManyRunnables(Map<String, Integer> counts) {
        StringBuilder classesWithTooManyRunnables = new StringBuilder();
        for (Map.Entry<String, Integer> entry : counts.entrySet()) {
            if (entry.getValue() <= 32) continue;
            classesWithTooManyRunnables.append(entry.getKey()).append(' ');
        }
        if (classesWithTooManyRunnables.length() == 0) {
            return "NO CLASSES FOUND";
        }
        return classesWithTooManyRunnables.toString();
    }

    @Override
    public void execute(Runnable r) {
        try {
            super.execute(r);
        }
        catch (RejectedExecutionException e) {
            Map<String, Integer> counts = this.getNumberOfClassNameOccurrencesInQueue();
            throw new RejectedExecutionException("Prominent classes in AsyncTask: " + this.findClassNamesWithTooManyRunnables(counts), e);
        }
    }
}

