/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.os.Handler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Log;
import org.chromium.base.ResettersForTesting;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.ChromeThreadPoolExecutor;
import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.TaskExecutor;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskRunnerImpl;
import org.chromium.base.task.ThreadPoolTaskExecutor;
import org.chromium.base.task.UiThreadTaskExecutor;

@JNINamespace(value="base")
public class PostTask {
    private static final String TAG = "PostTask";
    private static final Object sPreNativeTaskRunnerLock = new Object();
    @GuardedBy(value="sPreNativeTaskRunnerLock")
    private static List<TaskRunnerImpl> sPreNativeTaskRunners = new ArrayList<TaskRunnerImpl>();
    private static volatile boolean sNativeInitialized;
    private static ChromeThreadPoolExecutor sPrenativeThreadPoolExecutor;
    private static volatile Executor sPrenativeThreadPoolExecutorForTesting;
    private static final ThreadPoolTaskExecutor sThreadPoolTaskExecutor;
    private static UiThreadTaskExecutor sUiThreadTaskExecutor;
    static int sTestIterationForTesting;

    public static TaskRunner createTaskRunner(int taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).createTaskRunner(taskTraits);
    }

    public static SequencedTaskRunner createSequencedTaskRunner(int taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).createSequencedTaskRunner(taskTraits);
    }

    public static SingleThreadTaskRunner createSingleThreadTaskRunner(int taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).createSingleThreadTaskRunner(taskTraits);
    }

    public static void postTask(int taskTraits, Runnable task) {
        PostTask.postDelayedTask(taskTraits, task, 0L);
    }

    public static void postDelayedTask(int taskTraits, Runnable task, long delay) {
        PostTask.getTaskExecutorForTraits(taskTraits).postDelayedTask(taskTraits, task, delay);
    }

    public static void runOrPostTask(int taskTraits, Runnable task) {
        if (PostTask.getTaskExecutorForTraits(taskTraits).canRunTaskImmediately(taskTraits)) {
            task.run();
        } else {
            PostTask.postTask(taskTraits, task);
        }
    }

    public static boolean canRunTaskImmediately(int taskTraits) {
        return PostTask.getTaskExecutorForTraits(taskTraits).canRunTaskImmediately(taskTraits);
    }

    @Deprecated
    public static <T> T runSynchronously(int taskTraits, Callable<T> c) {
        return PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<T>(c));
    }

    @Deprecated
    public static void runSynchronously(int taskTraits, Runnable r) {
        PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<Object>(r, null));
    }

    private static <T> T runSynchronouslyInternal(int taskTraits, FutureTask<T> task) {
        PostTask.runOrPostTask(taskTraits, task);
        try {
            return task.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setPrenativeThreadPoolExecutorForTesting(Executor executor) {
        sPrenativeThreadPoolExecutorForTesting = executor;
        ResettersForTesting.register(() -> {
            sPrenativeThreadPoolExecutorForTesting = null;
        });
    }

    public static void resetPrenativeThreadPoolExecutorForTesting() {
        sPrenativeThreadPoolExecutorForTesting = null;
    }

    static Executor getPrenativeThreadPoolExecutor() {
        if (sPrenativeThreadPoolExecutorForTesting != null) {
            return sPrenativeThreadPoolExecutorForTesting;
        }
        return sPrenativeThreadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerPreNativeTaskRunner(TaskRunnerImpl taskRunner) {
        Object object = sPreNativeTaskRunnerLock;
        synchronized (object) {
            if (sPreNativeTaskRunners == null) {
                return false;
            }
            sPreNativeTaskRunners.add(taskRunner);
            return true;
        }
    }

    private static TaskExecutor getTaskExecutorForTraits(int traits) {
        if (traits >= 6) {
            if (sUiThreadTaskExecutor == null) {
                ThreadUtils.getUiThreadHandler();
            }
            return sUiThreadTaskExecutor;
        }
        return sThreadPoolTaskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static void onNativeSchedulerReady() {
        List<TaskRunnerImpl> preNativeTaskRunners;
        if (sNativeInitialized) {
            return;
        }
        sNativeInitialized = true;
        Iterator<TaskRunnerImpl> iterator = sPreNativeTaskRunnerLock;
        synchronized (iterator) {
            preNativeTaskRunners = sPreNativeTaskRunners;
            sPreNativeTaskRunners = null;
        }
        for (TaskRunnerImpl taskRunner : preNativeTaskRunners) {
            taskRunner.initNativeTaskRunner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushJobsAndResetForTesting() throws InterruptedException {
        ChromeThreadPoolExecutor executor = sPrenativeThreadPoolExecutor;
        int taskCount = executor.getQueue().size() + executor.getActiveCount();
        if (taskCount > 0) {
            executor.shutdownNow();
            executor.awaitTermination(1L, TimeUnit.SECONDS);
            sPrenativeThreadPoolExecutor = new ChromeThreadPoolExecutor();
        }
        Object object = sPreNativeTaskRunnerLock;
        synchronized (object) {
            if (sPreNativeTaskRunners != null) {
                for (TaskRunnerImpl taskRunner : sPreNativeTaskRunners) {
                    taskCount += taskRunner.clearTaskQueueForTesting();
                }
            }
            ++sTestIterationForTesting;
        }
        PostTask.resetPrenativeThreadPoolExecutorForTesting();
        if (taskCount > 0) {
            Log.w(TAG, "%d background task(s) existed after test finished.", (Object)taskCount);
        }
    }

    public static void onUiThreadReady(Handler uiThreadHandler) {
        assert (sUiThreadTaskExecutor == null);
        sUiThreadTaskExecutor = new UiThreadTaskExecutor(uiThreadHandler);
    }

    public static void resetUiThreadForTesting() {
        assert (!sNativeInitialized);
        sUiThreadTaskExecutor = null;
    }

    static {
        sPrenativeThreadPoolExecutor = new ChromeThreadPoolExecutor();
        sThreadPoolTaskExecutor = new ThreadPoolTaskExecutor();
    }
}

