/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import java.util.concurrent.atomic.AtomicInteger;
import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.TaskRunnerImpl;

public class SequencedTaskRunnerImpl
extends TaskRunnerImpl
implements SequencedTaskRunner {
    private AtomicInteger mPendingTasks = new AtomicInteger();
    private volatile boolean mReadyToCreateNativeTaskRunner;

    SequencedTaskRunnerImpl(int traits) {
        super(traits, "SequencedTaskRunnerImpl", 1);
    }

    @Override
    protected void schedulePreNativeTask() {
        if (this.mPendingTasks.getAndIncrement() == 0) {
            super.schedulePreNativeTask();
        }
    }

    @Override
    protected void runPreNativeTask() {
        super.runPreNativeTask();
        if (this.mPendingTasks.decrementAndGet() > 0) {
            if (!this.mReadyToCreateNativeTaskRunner) {
                super.schedulePreNativeTask();
            } else {
                super.initNativeTaskRunner();
            }
        }
    }

    @Override
    void initNativeTaskRunner() {
        this.mReadyToCreateNativeTaskRunner = true;
        if (this.mPendingTasks.getAndIncrement() == 0) {
            super.initNativeTaskRunner();
        }
    }
}

