/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.os.Handler;
import androidx.annotation.Nullable;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.TaskRunnerImpl;

@JNINamespace(value="base")
public class SingleThreadTaskRunnerImpl
extends TaskRunnerImpl
implements SingleThreadTaskRunner {
    @Nullable
    private final Handler mHandler;

    public SingleThreadTaskRunnerImpl(Handler handler, int traits) {
        super(traits, "SingleThreadTaskRunnerImpl", 2);
        this.mHandler = handler;
    }

    @Override
    public boolean belongsToCurrentThread() {
        Boolean belongs = this.belongsToCurrentThreadInternal();
        if (belongs != null) {
            return belongs;
        }
        assert (this.mHandler != null);
        return this.mHandler.getLooper().getThread() == Thread.currentThread();
    }

    @Override
    protected void schedulePreNativeTask() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.post(this.mRunPreNativeTaskClosure);
    }

    @Override
    protected boolean schedulePreNativeDelayedTask(Runnable task, long delay) {
        if (this.mHandler == null) {
            return false;
        }
        this.mHandler.postDelayed(task, delay);
        return true;
    }
}

