/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.os.Process;
import android.util.Pair;
import androidx.annotation.Nullable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.PostTask;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskRunnerImplJni;

@JNINamespace(value="base")
public class TaskRunnerImpl
implements TaskRunner {
    private static final ReferenceQueue<Object> sQueue = new ReferenceQueue();
    @GuardedBy(value="sCleaners")
    private static final Set<TaskRunnerCleaner> sCleaners = new HashSet<TaskRunnerCleaner>();
    private final int mTaskTraits;
    private final String mTraceEvent;
    private final int mTaskRunnerType;
    private volatile long mNativeTaskRunnerAndroid;
    protected final Runnable mRunPreNativeTaskClosure = this::runPreNativeTask;
    private final Object mPreNativeTaskLock = new Object();
    @GuardedBy(value="mPreNativeTaskLock")
    private boolean mDidOneTimeInitialization;
    @Nullable
    @GuardedBy(value="mPreNativeTaskLock")
    private LinkedList<Runnable> mPreNativeTasks;
    @Nullable
    @GuardedBy(value="mPreNativeTaskLock")
    private List<Pair<Runnable, Long>> mPreNativeDelayedTasks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clearTaskQueueForTesting() {
        int taskCount = 0;
        Object object = this.mPreNativeTaskLock;
        synchronized (object) {
            if (this.mPreNativeTasks != null) {
                taskCount = this.mPreNativeTasks.size() + this.mPreNativeDelayedTasks.size();
                this.mPreNativeTasks.clear();
                this.mPreNativeDelayedTasks.clear();
            }
        }
        return taskCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyGarbageCollectedTaskRunners() {
        TaskRunnerCleaner cleaner;
        while ((cleaner = (TaskRunnerCleaner)sQueue.poll()) != null) {
            cleaner.destroy();
            Set<TaskRunnerCleaner> set = sCleaners;
            synchronized (set) {
                sCleaners.remove(cleaner);
            }
        }
        return;
    }

    TaskRunnerImpl(int traits) {
        this(traits, "TaskRunnerImpl", 0);
        TaskRunnerImpl.destroyGarbageCollectedTaskRunners();
    }

    protected TaskRunnerImpl(int traits, String traceCategory, int taskRunnerType) {
        this.mTaskTraits = traits;
        this.mTraceEvent = traceCategory + ".PreNativeTask.run";
        this.mTaskRunnerType = taskRunnerType;
    }

    @Override
    public void postTask(Runnable task) {
        this.postDelayedTask(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDelayedTask(Runnable task, long delay) {
        if (this.mNativeTaskRunnerAndroid != 0L) {
            TaskRunnerImplJni.get().postDelayedTask(this.mNativeTaskRunnerAndroid, task, delay, task.getClass().getName());
            return;
        }
        Object object = this.mPreNativeTaskLock;
        synchronized (object) {
            this.oneTimeInitialization();
            if (this.mNativeTaskRunnerAndroid != 0L) {
                TaskRunnerImplJni.get().postDelayedTask(this.mNativeTaskRunnerAndroid, task, delay, task.getClass().getName());
                return;
            }
            if (delay == 0L) {
                this.mPreNativeTasks.add(task);
                this.schedulePreNativeTask();
            } else if (!this.schedulePreNativeDelayedTask(task, delay)) {
                Pair preNativeDelayedTask = new Pair((Object)task, (Object)delay);
                this.mPreNativeDelayedTasks.add((Pair<Runnable, Long>)preNativeDelayedTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean belongsToCurrentThreadInternal() {
        assert (!this.getClass().equals(TaskRunnerImpl.class));
        Object object = this.mPreNativeTaskLock;
        synchronized (object) {
            this.oneTimeInitialization();
        }
        if (this.mNativeTaskRunnerAndroid == 0L) {
            return null;
        }
        return TaskRunnerImplJni.get().belongsToCurrentThread(this.mNativeTaskRunnerAndroid);
    }

    @GuardedBy(value="mPreNativeTaskLock")
    private void oneTimeInitialization() {
        if (this.mDidOneTimeInitialization) {
            return;
        }
        this.mDidOneTimeInitialization = true;
        if (!PostTask.registerPreNativeTaskRunner(this)) {
            this.initNativeTaskRunner();
        } else {
            this.mPreNativeTasks = new LinkedList();
            this.mPreNativeDelayedTasks = new ArrayList<Pair<Runnable, Long>>();
        }
    }

    protected void schedulePreNativeTask() {
        PostTask.getPrenativeThreadPoolExecutor().execute(this.mRunPreNativeTaskClosure);
    }

    protected boolean schedulePreNativeDelayedTask(Runnable task, long delay) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPreNativeTask() {
        try (TraceEvent te = TraceEvent.scoped(this.mTraceEvent);){
            Runnable task;
            Object object = this.mPreNativeTaskLock;
            synchronized (object) {
                block16: {
                    if (this.mPreNativeTasks != null) break block16;
                    return;
                }
                task = this.mPreNativeTasks.poll();
            }
            switch (this.mTaskTraits) {
                case 0: 
                case 1: {
                    Process.setThreadPriority((int)10);
                    break;
                }
                case 2: 
                case 3: {
                    Process.setThreadPriority((int)0);
                    break;
                }
                case 4: 
                case 5: {
                    Process.setThreadPriority((int)-1);
                    break;
                }
            }
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNativeTaskRunner() {
        long nativeTaskRunnerAndroid = TaskRunnerImplJni.get().init(this.mTaskRunnerType, this.mTaskTraits);
        Set<TaskRunnerCleaner> set = this.mPreNativeTaskLock;
        synchronized (set) {
            if (this.mPreNativeTasks != null) {
                for (Runnable runnable : this.mPreNativeTasks) {
                    TaskRunnerImplJni.get().postDelayedTask(nativeTaskRunnerAndroid, runnable, 0L, runnable.getClass().getName());
                }
                this.mPreNativeTasks = null;
            }
            if (this.mPreNativeDelayedTasks != null) {
                for (Pair pair : this.mPreNativeDelayedTasks) {
                    TaskRunnerImplJni.get().postDelayedTask(nativeTaskRunnerAndroid, (Runnable)pair.first, (Long)pair.second, pair.getClass().getName());
                }
                this.mPreNativeDelayedTasks = null;
            }
            assert (this.mNativeTaskRunnerAndroid == 0L);
            this.mNativeTaskRunnerAndroid = nativeTaskRunnerAndroid;
        }
        set = sCleaners;
        synchronized (set) {
            sCleaners.add(new TaskRunnerCleaner(this));
        }
        TaskRunnerImpl.destroyGarbageCollectedTaskRunners();
    }

    private static class TaskRunnerCleaner
    extends WeakReference<TaskRunnerImpl> {
        final long mNativePtr;

        TaskRunnerCleaner(TaskRunnerImpl runner) {
            super(runner, sQueue);
            this.mNativePtr = runner.mNativeTaskRunnerAndroid;
        }

        void destroy() {
            TaskRunnerImplJni.get().destroy(this.mNativePtr);
        }
    }

    static interface Natives {
        public long init(int var1, int var2);

        public void destroy(long var1);

        public void postDelayedTask(long var1, Runnable var3, long var4, String var6);

        public boolean belongsToCurrentThread(long var1);
    }
}

