/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.SequencedTaskRunnerImpl;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.SingleThreadTaskRunnerImpl;
import org.chromium.base.task.TaskExecutor;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskRunnerImpl;

class ThreadPoolTaskExecutor
implements TaskExecutor {
    private static final int TRAITS_COUNT = 6;
    private final TaskRunner[] mTraitsToRunnerMap = new TaskRunner[6];

    public ThreadPoolTaskExecutor() {
        for (int i = 0; i < 6; ++i) {
            this.mTraitsToRunnerMap[i] = this.createTaskRunner(0 + i);
        }
    }

    @Override
    public TaskRunner createTaskRunner(int taskTraits) {
        return new TaskRunnerImpl(taskTraits);
    }

    @Override
    public SequencedTaskRunner createSequencedTaskRunner(int taskTraits) {
        return new SequencedTaskRunnerImpl(taskTraits);
    }

    @Override
    public SingleThreadTaskRunner createSingleThreadTaskRunner(int taskTraits) {
        return new SingleThreadTaskRunnerImpl(null, taskTraits);
    }

    @Override
    public void postDelayedTask(int taskTraits, Runnable task, long delay) {
        int index = taskTraits - 0;
        this.mTraitsToRunnerMap[index].postDelayedTask(task, delay);
    }

    @Override
    public boolean canRunTaskImmediately(int traits) {
        return false;
    }
}

