/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.os.Handler;
import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.SingleThreadTaskRunnerImpl;
import org.chromium.base.task.TaskExecutor;
import org.chromium.base.task.TaskRunner;

public class UiThreadTaskExecutor
implements TaskExecutor {
    private static boolean sRegistered;
    private final SingleThreadTaskRunner mBestEffortTaskRunner;
    private final SingleThreadTaskRunner mUserVisibleTaskRunner;
    private final SingleThreadTaskRunner mUserBlockingTaskRunner;

    public UiThreadTaskExecutor(Handler handler) {
        this.mBestEffortTaskRunner = new SingleThreadTaskRunnerImpl(handler, 6);
        this.mUserVisibleTaskRunner = new SingleThreadTaskRunnerImpl(handler, 7);
        this.mUserBlockingTaskRunner = new SingleThreadTaskRunnerImpl(handler, 8);
    }

    @Override
    public TaskRunner createTaskRunner(int taskTraits) {
        return this.createSingleThreadTaskRunner(taskTraits);
    }

    @Override
    public SequencedTaskRunner createSequencedTaskRunner(int taskTraits) {
        return this.createSingleThreadTaskRunner(taskTraits);
    }

    @Override
    public SingleThreadTaskRunner createSingleThreadTaskRunner(int taskTraits) {
        if (6 == taskTraits) {
            return this.mBestEffortTaskRunner;
        }
        if (7 == taskTraits) {
            return this.mUserVisibleTaskRunner;
        }
        if (8 == taskTraits) {
            return this.mUserBlockingTaskRunner;
        }
        throw new RuntimeException();
    }

    @Override
    public void postDelayedTask(int taskTraits, Runnable task, long delay) {
        this.createSingleThreadTaskRunner(taskTraits).postDelayedTask(task, delay);
    }

    @Override
    public boolean canRunTaskImmediately(int traits) {
        return this.createSingleThreadTaskRunner(traits).belongsToCurrentThread();
    }
}

