/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidCertVerifyResult {
    private final int mStatus;
    private final boolean mIsIssuedByKnownRoot;
    private final List<X509Certificate> mCertificateChain;

    public AndroidCertVerifyResult(int status, boolean isIssuedByKnownRoot, List<X509Certificate> certificateChain) {
        this.mStatus = status;
        this.mIsIssuedByKnownRoot = isIssuedByKnownRoot;
        this.mCertificateChain = new ArrayList<X509Certificate>(certificateChain);
    }

    public AndroidCertVerifyResult(int status) {
        this.mStatus = status;
        this.mIsIssuedByKnownRoot = false;
        this.mCertificateChain = Collections.emptyList();
    }

    @CalledByNative
    public int getStatus() {
        return this.mStatus;
    }

    @CalledByNative
    public boolean isIssuedByKnownRoot() {
        return this.mIsIssuedByKnownRoot;
    }

    @CalledByNative
    public byte[][] getCertificateChainEncoded() {
        byte[][] verifiedChainArray = new byte[this.mCertificateChain.size()][];
        try {
            for (int i = 0; i < this.mCertificateChain.size(); ++i) {
                verifiedChainArray[i] = this.mCertificateChain.get(i).getEncoded();
            }
        }
        catch (CertificateEncodingException e) {
            return new byte[0][];
        }
        return verifiedChainArray;
    }
}

