/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidKeyStore {
    private static final String TAG = "AndroidKeyStore";

    @CalledByNative
    private static String getPrivateKeyClassName(PrivateKey privateKey) {
        return privateKey.getClass().getName();
    }

    @CalledByNative
    private static boolean privateKeySupportsSignature(PrivateKey privateKey, String algorithm) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            return false;
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while checking support for " + algorithm + ": " + e);
            return false;
        }
        return true;
    }

    @CalledByNative
    private static boolean privateKeySupportsCipher(PrivateKey privateKey, String algorithm) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, privateKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            return false;
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while checking support for " + algorithm + ": " + e);
            return false;
        }
        return true;
    }

    @CalledByNative
    private static byte[] signWithPrivateKey(PrivateKey privateKey, String algorithm, byte[] message) {
        Signature signature = null;
        try {
            signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            Log.e(TAG, "Signature algorithm " + algorithm + " not supported: " + e);
            return null;
        }
        try {
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while signing message with " + algorithm + " and " + privateKey.getAlgorithm() + " private key (" + privateKey.getClass().getName() + "): " + e);
            return null;
        }
    }

    @CalledByNative
    private static byte[] encryptWithPrivateKey(PrivateKey privateKey, String algorithm, byte[] message) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            Log.e(TAG, "Cipher " + algorithm + " not supported: " + e);
            return null;
        }
        try {
            cipher.init(1, privateKey);
            return cipher.doFinal(message);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while encrypting input with " + algorithm + " and " + privateKey.getAlgorithm() + " private key (" + privateKey.getClass().getName() + "): " + e);
            return null;
        }
    }
}

