/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.net.HttpNegotiateAuthenticatorJni;

@JNINamespace(value="net::android")
public class HttpNegotiateAuthenticator {
    private static final String TAG = "net_auth";
    private Bundle mSpnegoContext;
    private final String mAccountType;

    protected HttpNegotiateAuthenticator(String accountType) {
        assert (!TextUtils.isEmpty((CharSequence)accountType));
        this.mAccountType = accountType;
    }

    @VisibleForTesting
    @CalledByNative
    static HttpNegotiateAuthenticator create(String accountType) {
        return new HttpNegotiateAuthenticator(accountType);
    }

    @VisibleForTesting
    @CalledByNative
    void getNextAuthToken(long nativeResultObject, String principal, String authToken, boolean canDelegate) {
        assert (principal != null);
        Context applicationContext = ContextUtils.getApplicationContext();
        RequestData requestData = new RequestData();
        requestData.authTokenType = "SPNEGO:HOSTBASED:" + principal;
        requestData.accountManager = AccountManager.get((Context)applicationContext);
        requestData.nativeResultObject = nativeResultObject;
        String[] features = new String[]{"SPNEGO"};
        requestData.options = new Bundle();
        if (authToken != null) {
            requestData.options.putString("incomingAuthToken", authToken);
        }
        if (this.mSpnegoContext != null) {
            requestData.options.putBundle("spnegoContext", this.mSpnegoContext);
        }
        requestData.options.putBoolean("canDelegate", canDelegate);
        Activity activity = ApplicationStatus.getLastTrackedFocusedActivity();
        if (activity == null) {
            this.requestTokenWithoutActivity(applicationContext, requestData, features);
        } else {
            this.requestTokenWithActivity(applicationContext, activity, requestData, features);
        }
    }

    private void processResult(Bundle result, RequestData requestData) {
        int status;
        this.mSpnegoContext = result.getBundle("spnegoContext");
        switch (result.getInt("spnegoResult", 1)) {
            case 0: {
                status = 0;
                break;
            }
            case 1: {
                status = -9;
                break;
            }
            case 2: {
                status = -3;
                break;
            }
            case 3: {
                status = -342;
                break;
            }
            case 4: {
                status = -320;
                break;
            }
            case 5: {
                status = -338;
                break;
            }
            case 6: {
                status = -339;
                break;
            }
            case 7: {
                status = -341;
                break;
            }
            case 8: {
                status = -344;
                break;
            }
            case 9: {
                status = -329;
                break;
            }
            default: {
                status = -9;
            }
        }
        HttpNegotiateAuthenticatorJni.get().setResult(requestData.nativeResultObject, this, status, result.getString("authtoken"));
    }

    private void requestTokenWithoutActivity(Context ctx, RequestData requestData, String[] features) {
        if (this.lacksPermission(ctx, "android.permission.GET_ACCOUNTS", true)) {
            Log.e(TAG, "ERR_MISCONFIGURED_AUTH_ENVIRONMENT: GET_ACCOUNTS permission not granted. Aborting authentication.");
            HttpNegotiateAuthenticatorJni.get().setResult(requestData.nativeResultObject, this, -343, null);
            return;
        }
        requestData.accountManager.getAccountsByTypeAndFeatures(this.mAccountType, features, (AccountManagerCallback)new GetAccountsCallback(requestData), new Handler(ThreadUtils.getUiThreadLooper()));
    }

    private void requestTokenWithActivity(Context ctx, Activity activity, RequestData requestData, String[] features) {
        String permission2;
        boolean isPreM = Build.VERSION.SDK_INT < 23;
        String string2 = permission2 = isPreM ? "android.permission.MANAGE_ACCOUNTS" : "android.permission.GET_ACCOUNTS";
        if (this.lacksPermission(ctx, permission2, isPreM)) {
            Log.e(TAG, "ERR_MISCONFIGURED_AUTH_ENVIRONMENT: %s permission not granted. Aborting authentication", (Object)permission2);
            HttpNegotiateAuthenticatorJni.get().setResult(requestData.nativeResultObject, this, -343, null);
            return;
        }
        requestData.accountManager.getAuthTokenByFeatures(this.mAccountType, requestData.authTokenType, features, activity, null, requestData.options, (AccountManagerCallback)new GetTokenCallback(requestData), new Handler(ThreadUtils.getUiThreadLooper()));
    }

    @VisibleForTesting
    boolean lacksPermission(Context context, String permission2, boolean onlyPreM) {
        if (onlyPreM && Build.VERSION.SDK_INT >= 23) {
            return false;
        }
        int permissionResult = context.checkPermission(permission2, Process.myPid(), Process.myUid());
        return permissionResult != 0;
    }

    static class RequestData {
        public long nativeResultObject;
        public AccountManager accountManager;
        public Bundle options;
        public String authTokenType;
        public Account account;

        RequestData() {
        }
    }

    static interface Natives {
        public void setResult(long var1, HttpNegotiateAuthenticator var3, int var4, String var5);
    }

    @VisibleForTesting
    class GetAccountsCallback
    implements AccountManagerCallback<Account[]> {
        private final RequestData mRequestData;

        public GetAccountsCallback(RequestData requestData) {
            this.mRequestData = requestData;
        }

        public void run(AccountManagerFuture<Account[]> future) {
            Account[] accounts;
            try {
                accounts = (Account[])future.getResult();
            }
            catch (AuthenticatorException | OperationCanceledException | IOException e) {
                Log.w(HttpNegotiateAuthenticator.TAG, "ERR_UNEXPECTED: Error while attempting to retrieve accounts.", e);
                HttpNegotiateAuthenticatorJni.get().setResult(this.mRequestData.nativeResultObject, HttpNegotiateAuthenticator.this, -9, null);
                return;
            }
            if (accounts.length == 0) {
                Log.w(HttpNegotiateAuthenticator.TAG, "ERR_MISSING_AUTH_CREDENTIALS: No account provided for the kerberos authentication. Please verify the configuration policies and that the CONTACTS runtime permission is granted. ");
                HttpNegotiateAuthenticatorJni.get().setResult(this.mRequestData.nativeResultObject, HttpNegotiateAuthenticator.this, -341, null);
                return;
            }
            if (accounts.length > 1) {
                Log.w(HttpNegotiateAuthenticator.TAG, "ERR_MISSING_AUTH_CREDENTIALS: Found %d accounts eligible for the kerberos authentication. Please fix the configuration by providing a single account.", (Object)accounts.length);
                HttpNegotiateAuthenticatorJni.get().setResult(this.mRequestData.nativeResultObject, HttpNegotiateAuthenticator.this, -341, null);
                return;
            }
            if (HttpNegotiateAuthenticator.this.lacksPermission(ContextUtils.getApplicationContext(), "android.permission.USE_CREDENTIALS", true)) {
                Log.e(HttpNegotiateAuthenticator.TAG, "ERR_MISCONFIGURED_AUTH_ENVIRONMENT: USE_CREDENTIALS permission not granted. Aborting authentication.");
                HttpNegotiateAuthenticatorJni.get().setResult(this.mRequestData.nativeResultObject, HttpNegotiateAuthenticator.this, -343, null);
                return;
            }
            this.mRequestData.account = accounts[0];
            this.mRequestData.accountManager.getAuthToken(this.mRequestData.account, this.mRequestData.authTokenType, this.mRequestData.options, true, (AccountManagerCallback)new GetTokenCallback(this.mRequestData), new Handler(ThreadUtils.getUiThreadLooper()));
        }
    }

    @VisibleForTesting
    class GetTokenCallback
    implements AccountManagerCallback<Bundle> {
        private final RequestData mRequestData;

        public GetTokenCallback(RequestData requestData) {
            this.mRequestData = requestData;
        }

        public void run(AccountManagerFuture<Bundle> future) {
            Bundle result;
            try {
                result = (Bundle)future.getResult();
            }
            catch (AuthenticatorException | OperationCanceledException | IOException e) {
                Log.w(HttpNegotiateAuthenticator.TAG, "ERR_UNEXPECTED: Error while attempting to obtain a token.", e);
                HttpNegotiateAuthenticatorJni.get().setResult(this.mRequestData.nativeResultObject, HttpNegotiateAuthenticator.this, -9, null);
                return;
            }
            if (result.containsKey("intent")) {
                final Context appContext = ContextUtils.getApplicationContext();
                BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        appContext.unregisterReceiver((BroadcastReceiver)this);
                        GetTokenCallback.this.mRequestData.accountManager.getAuthToken(GetTokenCallback.this.mRequestData.account, GetTokenCallback.this.mRequestData.authTokenType, GetTokenCallback.this.mRequestData.options, true, (AccountManagerCallback)new GetTokenCallback(GetTokenCallback.this.mRequestData), null);
                    }
                };
                ContextUtils.registerProtectedBroadcastReceiver(appContext, broadcastReceiver, new IntentFilter("android.accounts.LOGIN_ACCOUNTS_CHANGED"));
            } else {
                HttpNegotiateAuthenticator.this.processResult(result, this.mRequestData);
            }
        }
    }
}

