/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class MimeTypeFilter
implements FileFilter {
    private HashSet<String> mExtensions = new HashSet();
    private HashSet<String> mMimeTypes = new HashSet();
    private HashSet<String> mMimeSupertypes = new HashSet();
    private MimeTypeMap mMimeTypeMap;
    private boolean mAcceptAllMimeTypes;
    private boolean mAcceptDirectory;

    public MimeTypeFilter(@NonNull List<String> mimeTypes, boolean acceptDirectory) {
        for (String field : mimeTypes) {
            if ((field = field.trim().toLowerCase(Locale.US)).startsWith(".")) {
                this.mExtensions.add(field.substring(1));
                continue;
            }
            if (field.equals("*/*")) {
                this.mAcceptAllMimeTypes = true;
                continue;
            }
            if (field.endsWith("/*")) {
                this.mMimeSupertypes.add(field.substring(0, field.length() - 2));
                continue;
            }
            if (!field.contains("/")) continue;
            this.mMimeTypes.add(field);
        }
        this.mMimeTypeMap = MimeTypeMap.getSingleton();
        this.mAcceptDirectory = acceptDirectory;
    }

    public boolean accept(Uri uri, String mimeType) {
        if (uri != null) {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString()).toLowerCase(Locale.US);
            if (this.mExtensions.contains(fileExtension)) {
                return true;
            }
            if (mimeType == null) {
                mimeType = this.getMimeTypeFromExtension(fileExtension);
            }
        }
        return mimeType != null && (this.mAcceptAllMimeTypes || this.mMimeTypes.contains(mimeType) || this.mMimeSupertypes.contains(MimeTypeFilter.getMimeSupertype(mimeType)));
    }

    @Override
    public boolean accept(@NonNull File file) {
        if (file.isDirectory()) {
            return this.mAcceptDirectory;
        }
        return this.accept(Uri.fromFile((File)file), null);
    }

    private String getMimeTypeFromExtension(@NonNull String ext) {
        String mimeType = this.mMimeTypeMap.getMimeTypeFromExtension(ext);
        return mimeType != null ? mimeType.toLowerCase(Locale.US) : null;
    }

    @NonNull
    private static String getMimeSupertype(@NonNull String mimeType) {
        return mimeType.split("/", 2)[0];
    }
}

