/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.Context;
import android.net.ConnectivityManager;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.net.NetworkActiveNotifierJni;

@JNINamespace(value="net")
public class NetworkActiveNotifier
implements ConnectivityManager.OnNetworkActiveListener {
    private final ConnectivityManager mConnectivityManager;
    private final long mNativeNetworkActiveObserver;
    private boolean mAreNotificationsEnabled;

    @CalledByNative
    public static NetworkActiveNotifier build(long nativeNetworkActiveNotifier) {
        return new NetworkActiveNotifier(nativeNetworkActiveNotifier);
    }

    @CalledByNative
    public void enableNotifications() {
        this.mAreNotificationsEnabled = true;
        this.mConnectivityManager.addDefaultNetworkActiveListener((ConnectivityManager.OnNetworkActiveListener)this);
    }

    @CalledByNative
    public void disableNotifications() {
        this.mAreNotificationsEnabled = false;
        this.mConnectivityManager.removeDefaultNetworkActiveListener((ConnectivityManager.OnNetworkActiveListener)this);
    }

    @CalledByNative
    public boolean isDefaultNetworkActive() {
        return this.mConnectivityManager.isDefaultNetworkActive();
    }

    public void onNetworkActive() {
        NetworkActiveNotifierJni.get().notifyOfDefaultNetworkActive(this.mNativeNetworkActiveObserver);
    }

    @CalledByNative
    public void fakeDefaultNetworkActive() {
        if (this.mAreNotificationsEnabled) {
            this.onNetworkActive();
        }
    }

    private NetworkActiveNotifier(long nativeNetworkActiveNotifier) {
        this.mNativeNetworkActiveObserver = nativeNetworkActiveNotifier;
        Context ctx = ContextUtils.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)ctx.getSystemService("connectivity");
    }

    static interface Natives {
        @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
        public void notifyOfDefaultNetworkActive(long var1);
    }
}

