/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ContextUtils;
import org.chromium.base.ResettersForTesting;
import org.chromium.base.StrictModeContext;
import org.chromium.base.TraceEvent;
import org.chromium.base.compat.ApiHelperForM;
import org.chromium.base.compat.ApiHelperForO;
import org.chromium.base.compat.ApiHelperForP;
import org.chromium.build.BuildConfig;
import org.chromium.net.AndroidNetworkLibrary;
import org.chromium.net.DnsStatus;

@SuppressLint(value={"NewApi"})
public class NetworkChangeNotifierAutoDetect
extends BroadcastReceiver {
    private static final String TAG = NetworkChangeNotifierAutoDetect.class.getSimpleName();
    private static final int UNKNOWN_LINK_SPEED = -1;
    private final Looper mLooper = Looper.myLooper();
    private final Handler mHandler = new Handler(this.mLooper);
    private final NetworkConnectivityIntentFilter mIntentFilter;
    private final Observer mObserver;
    private final RegistrationPolicy mRegistrationPolicy;
    private ConnectivityManager.NetworkCallback mDefaultNetworkCallback;
    private ConnectivityManagerDelegate mConnectivityManagerDelegate;
    private WifiManagerDelegate mWifiManagerDelegate;
    private MyNetworkCallback mNetworkCallback;
    private NetworkRequest mNetworkRequest;
    private boolean mRegistered;
    private NetworkState mNetworkState;
    private boolean mIgnoreNextBroadcast;
    private boolean mShouldSignalObserver;
    private boolean mRegisterNetworkCallbackFailed;

    public NetworkChangeNotifierAutoDetect(Observer observer, RegistrationPolicy policy) {
        this.mObserver = observer;
        this.mConnectivityManagerDelegate = new ConnectivityManagerDelegate(ContextUtils.getApplicationContext());
        if (Build.VERSION.SDK_INT < 23) {
            this.mWifiManagerDelegate = new WifiManagerDelegate(ContextUtils.getApplicationContext());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mNetworkCallback = new MyNetworkCallback();
            this.mNetworkRequest = new NetworkRequest.Builder().addCapability(12).removeCapability(15).build();
        } else {
            this.mNetworkCallback = null;
            this.mNetworkRequest = null;
        }
        this.mDefaultNetworkCallback = Build.VERSION.SDK_INT >= 30 ? new AndroidRDefaultNetworkCallback() : (Build.VERSION.SDK_INT >= 28 ? new DefaultNetworkCallback() : null);
        this.mNetworkState = this.getCurrentNetworkState();
        this.mIntentFilter = new NetworkConnectivityIntentFilter();
        this.mIgnoreNextBroadcast = false;
        this.mShouldSignalObserver = false;
        this.mRegistrationPolicy = policy;
        this.mRegistrationPolicy.init(this);
        this.mShouldSignalObserver = true;
    }

    private boolean onThread() {
        return this.mLooper == Looper.myLooper();
    }

    private void assertOnThread() {
        if (BuildConfig.ENABLE_ASSERTS && !this.onThread()) {
            throw new IllegalStateException("Must be called on NetworkChangeNotifierAutoDetect thread.");
        }
    }

    private void runOnThread(Runnable r) {
        if (this.onThread()) {
            r.run();
        } else {
            this.mHandler.post(() -> {
                if (this.mRegistered) {
                    r.run();
                }
            });
        }
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate delegate) {
        ConnectivityManagerDelegate oldValue = this.mConnectivityManagerDelegate;
        this.mConnectivityManagerDelegate = delegate;
        ResettersForTesting.register(() -> {
            this.mConnectivityManagerDelegate = oldValue;
        });
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate delegate) {
        WifiManagerDelegate oldValue = this.mWifiManagerDelegate;
        this.mWifiManagerDelegate = delegate;
        ResettersForTesting.register(() -> {
            this.mWifiManagerDelegate = oldValue;
        });
    }

    @VisibleForTesting
    RegistrationPolicy getRegistrationPolicy() {
        return this.mRegistrationPolicy;
    }

    boolean isReceiverRegisteredForTesting() {
        return this.mRegistered;
    }

    public void destroy() {
        this.assertOnThread();
        this.mRegistrationPolicy.destroy();
        this.unregister();
    }

    public void register() {
        this.assertOnThread();
        if (this.mRegistered) {
            this.connectionTypeChanged();
            return;
        }
        if (this.mShouldSignalObserver) {
            this.connectionTypeChanged();
        }
        if (this.mDefaultNetworkCallback != null) {
            try {
                this.mConnectivityManagerDelegate.registerDefaultNetworkCallback(this.mDefaultNetworkCallback, this.mHandler);
            }
            catch (RuntimeException e) {
                this.mDefaultNetworkCallback = null;
            }
        }
        if (this.mDefaultNetworkCallback == null) {
            this.mIgnoreNextBroadcast = ContextUtils.registerProtectedBroadcastReceiver(ContextUtils.getApplicationContext(), this, this.mIntentFilter) != null;
        }
        this.mRegistered = true;
        if (this.mNetworkCallback != null) {
            this.mNetworkCallback.initializeVpnInPlace();
            try {
                this.mConnectivityManagerDelegate.registerNetworkCallback(this.mNetworkRequest, this.mNetworkCallback, this.mHandler);
            }
            catch (RuntimeException e) {
                this.mRegisterNetworkCallbackFailed = true;
                this.mNetworkCallback = null;
            }
            if (!this.mRegisterNetworkCallbackFailed && this.mShouldSignalObserver) {
                Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
                long[] netIds = new long[networks.length];
                for (int i = 0; i < networks.length; ++i) {
                    netIds[i] = NetworkChangeNotifierAutoDetect.networkToNetId(networks[i]);
                }
                this.mObserver.purgeActiveNetworkList(netIds);
            }
        }
    }

    public void unregister() {
        this.assertOnThread();
        if (!this.mRegistered) {
            return;
        }
        this.mRegistered = false;
        if (this.mNetworkCallback != null) {
            this.mConnectivityManagerDelegate.unregisterNetworkCallback(this.mNetworkCallback);
        }
        if (this.mDefaultNetworkCallback != null) {
            this.mConnectivityManagerDelegate.unregisterNetworkCallback(this.mDefaultNetworkCallback);
        } else {
            ContextUtils.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public NetworkState getCurrentNetworkState() {
        return this.mConnectivityManagerDelegate.getNetworkState(this.mWifiManagerDelegate);
    }

    private static Network[] getAllNetworksFiltered(ConnectivityManagerDelegate connectivityManagerDelegate, Network ignoreNetwork) {
        Network[] networks = connectivityManagerDelegate.getAllNetworksUnfiltered();
        int filteredIndex = 0;
        for (Network network : networks) {
            NetworkCapabilities capabilities;
            if (network.equals((Object)ignoreNetwork) || (capabilities = connectivityManagerDelegate.getNetworkCapabilities(network)) == null || !capabilities.hasCapability(12)) continue;
            if (capabilities.hasTransport(4)) {
                if (!connectivityManagerDelegate.vpnAccessible(network)) continue;
                return new Network[]{network};
            }
            networks[filteredIndex++] = network;
        }
        return Arrays.copyOf(networks, filteredIndex);
    }

    public Network[] getNetworksForTesting() {
        return NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
    }

    public long[] getNetworksAndTypes() {
        if (Build.VERSION.SDK_INT < 21) {
            return new long[0];
        }
        Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
        long[] networksAndTypes = new long[networks.length * 2];
        int index = 0;
        for (Network network : networks) {
            networksAndTypes[index++] = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            networksAndTypes[index++] = this.mConnectivityManagerDelegate.getConnectionType(network);
        }
        return networksAndTypes;
    }

    public Network getDefaultNetwork() {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        return this.mConnectivityManagerDelegate.getDefaultNetwork();
    }

    public long getDefaultNetId() {
        Network network = this.getDefaultNetwork();
        return network == null ? -1L : NetworkChangeNotifierAutoDetect.networkToNetId(network);
    }

    public boolean registerNetworkCallbackFailed() {
        return this.mRegisterNetworkCallbackFailed;
    }

    private static int convertToConnectionType(int type, int subtype) {
        switch (type) {
            case 9: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 0: 
            case 4: 
            case 5: {
                switch (subtype) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 3;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 4;
                    }
                    case 13: {
                        return 5;
                    }
                    case 20: {
                        return 8;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public void onReceive(Context context, Intent intent) {
        this.runOnThread(new Runnable(){

            @Override
            public void run() {
                if (NetworkChangeNotifierAutoDetect.this.mIgnoreNextBroadcast) {
                    NetworkChangeNotifierAutoDetect.this.mIgnoreNextBroadcast = false;
                    return;
                }
                NetworkChangeNotifierAutoDetect.this.connectionTypeChanged();
            }
        });
    }

    private void connectionTypeChanged() {
        this.connectionTypeChangedTo(this.getCurrentNetworkState());
    }

    private void connectionTypeChangedTo(NetworkState networkState) {
        if (networkState.getConnectionType() != this.mNetworkState.getConnectionType() || !networkState.getNetworkIdentifier().equals(this.mNetworkState.getNetworkIdentifier()) || networkState.isPrivateDnsActive() != this.mNetworkState.isPrivateDnsActive() || !networkState.getPrivateDnsServerName().equals(this.mNetworkState.getPrivateDnsServerName())) {
            this.mObserver.onConnectionTypeChanged(networkState.getConnectionType());
        }
        if (networkState.getConnectionType() != this.mNetworkState.getConnectionType() || networkState.getConnectionSubtype() != this.mNetworkState.getConnectionSubtype()) {
            this.mObserver.onConnectionSubtypeChanged(networkState.getConnectionSubtype());
        }
        if (networkState.getConnectionCost() != this.mNetworkState.getConnectionCost()) {
            this.mObserver.onConnectionCostChanged(networkState.getConnectionCost());
        }
        this.mNetworkState = networkState;
    }

    public static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT >= 23) {
            return ApiHelperForM.getNetworkHandle(network);
        }
        return Integer.parseInt(network.toString());
    }

    public static interface Observer {
        public void onConnectionTypeChanged(int var1);

        public void onConnectionCostChanged(int var1);

        public void onConnectionSubtypeChanged(int var1);

        public void onNetworkConnect(long var1, int var3);

        public void onNetworkSoonToDisconnect(long var1);

        public void onNetworkDisconnect(long var1);

        public void purgeActiveNetworkList(long[] var1);
    }

    static class ConnectivityManagerDelegate {
        private final ConnectivityManager mConnectivityManager;

        ConnectivityManagerDelegate(Context context) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.mConnectivityManager = null;
        }

        private NetworkInfo processActiveNetworkInfo(NetworkInfo networkInfo) {
            if (networkInfo == null) {
                return null;
            }
            if (networkInfo.isConnected()) {
                return networkInfo;
            }
            if (Build.VERSION.SDK_INT < 21) {
                return null;
            }
            if (networkInfo.getDetailedState() != NetworkInfo.DetailedState.BLOCKED) {
                return null;
            }
            if (ApplicationStatus.getStateForApplication() != 1) {
                return null;
            }
            return networkInfo;
        }

        NetworkState getNetworkState(WifiManagerDelegate wifiManagerDelegate) {
            NetworkInfo networkInfo;
            Network network = null;
            if (Build.VERSION.SDK_INT >= 23) {
                network = this.getDefaultNetwork();
                networkInfo = this.getNetworkInfo(network);
            } else {
                networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            }
            networkInfo = this.processActiveNetworkInfo(networkInfo);
            if (networkInfo == null) {
                return new NetworkState(false, -1, -1, false, null, false, "");
            }
            if (network != null) {
                NetworkCapabilities capabilities = this.getNetworkCapabilities(network);
                boolean isMetered = capabilities != null && !capabilities.hasCapability(11);
                DnsStatus dnsStatus = AndroidNetworkLibrary.getDnsStatus(network);
                if (dnsStatus == null) {
                    return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), isMetered, String.valueOf(NetworkChangeNotifierAutoDetect.networkToNetId(network)), false, "");
                }
                return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), isMetered, String.valueOf(NetworkChangeNotifierAutoDetect.networkToNetId(network)), dnsStatus.getPrivateDnsActive(), dnsStatus.getPrivateDnsServerName());
            }
            assert (Build.VERSION.SDK_INT < 23);
            if (networkInfo.getType() == 1) {
                if (networkInfo.getExtraInfo() != null && !"".equals(networkInfo.getExtraInfo())) {
                    return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), false, networkInfo.getExtraInfo(), false, "");
                }
                return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), false, wifiManagerDelegate.getWifiSsid(), false, "");
            }
            return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), false, null, false, "");
        }

        NetworkInfo getRawNetworkInfo(Network network) {
            try {
                return this.mConnectivityManager.getNetworkInfo(network);
            }
            catch (NullPointerException firstException) {
                try {
                    return this.mConnectivityManager.getNetworkInfo(network);
                }
                catch (NullPointerException secondException) {
                    return null;
                }
            }
        }

        NetworkInfo getNetworkInfo(Network network) {
            NetworkInfo networkInfo = this.getRawNetworkInfo(network);
            if (networkInfo != null && networkInfo.getType() == 17) {
                networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            }
            return networkInfo;
        }

        int getConnectionType(Network network) {
            NetworkInfo networkInfo = this.getNetworkInfo(network);
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkChangeNotifierAutoDetect.convertToConnectionType(networkInfo.getType(), networkInfo.getSubtype());
            }
            return 6;
        }

        @VisibleForTesting
        protected Network[] getAllNetworksUnfiltered() {
            Network[] networks = this.mConnectivityManager.getAllNetworks();
            return networks == null ? new Network[]{} : networks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        protected boolean vpnAccessible(Network network) {
            Socket s = new Socket();
            try (StrictModeContext ignored = StrictModeContext.allowAllVmPolicies();){
                network.bindSocket(s);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }

        @VisibleForTesting
        protected NetworkCapabilities getNetworkCapabilities(Network network) {
            int retryCount = 2;
            for (int i = 0; i < 2; ++i) {
                try {
                    return this.mConnectivityManager.getNetworkCapabilities(network);
                }
                catch (SecurityException securityException) {
                    continue;
                }
            }
            return null;
        }

        void registerNetworkCallback(NetworkRequest networkRequest, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
            if (Build.VERSION.SDK_INT >= 26) {
                try (StrictModeContext ignored = StrictModeContext.allowDiskReads();){
                    this.mConnectivityManager.registerNetworkCallback(networkRequest, networkCallback, handler);
                }
            } else {
                this.mConnectivityManager.registerNetworkCallback(networkRequest, networkCallback);
            }
        }

        @RequiresApi(value=28)
        void registerDefaultNetworkCallback(ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
            ApiHelperForO.registerDefaultNetworkCallback(this.mConnectivityManager, networkCallback, handler);
        }

        void unregisterNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.mConnectivityManager.unregisterNetworkCallback(networkCallback);
        }

        Network getDefaultNetwork() {
            Network[] networks;
            Network defaultNetwork = null;
            if (Build.VERSION.SDK_INT >= 23 && (defaultNetwork = ApiHelperForM.getActiveNetwork(this.mConnectivityManager)) != null) {
                return defaultNetwork;
            }
            NetworkInfo defaultNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (defaultNetworkInfo == null) {
                return null;
            }
            for (Network network : networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this, null)) {
                NetworkInfo networkInfo = this.getRawNetworkInfo(network);
                if (networkInfo == null || networkInfo.getType() != defaultNetworkInfo.getType() && networkInfo.getType() != 17) continue;
                if (defaultNetwork != null && Build.VERSION.SDK_INT >= 29) {
                    if (networkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTING) continue;
                    NetworkInfo prevDefaultNetworkInfo = this.getRawNetworkInfo(defaultNetwork);
                    if (prevDefaultNetworkInfo != null && prevDefaultNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTING) {
                        defaultNetwork = null;
                    }
                }
                assert (defaultNetwork == null);
                defaultNetwork = network;
            }
            return defaultNetwork;
        }
    }

    static class WifiManagerDelegate {
        private final Context mContext;
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private boolean mHasWifiPermissionComputed;
        @GuardedBy(value="mLock")
        private boolean mHasWifiPermission;
        @GuardedBy(value="mLock")
        private WifiManager mWifiManager;

        WifiManagerDelegate(Context context) {
            assert (Build.VERSION.SDK_INT < 23);
            this.mContext = context;
        }

        WifiManagerDelegate() {
            this.mContext = null;
        }

        @GuardedBy(value="mLock")
        @SuppressLint(value={"WifiManagerPotentialLeak"})
        private boolean hasPermissionLocked() {
            if (this.mHasWifiPermissionComputed) {
                return this.mHasWifiPermission;
            }
            this.mHasWifiPermission = this.mContext.getPackageManager().checkPermission("android.permission.ACCESS_WIFI_STATE", this.mContext.getPackageName()) == 0;
            this.mWifiManager = this.mHasWifiPermission ? (WifiManager)this.mContext.getSystemService("wifi") : null;
            this.mHasWifiPermissionComputed = true;
            return this.mHasWifiPermission;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getWifiSsid() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.hasPermissionLocked()) {
                    WifiInfo wifiInfo = this.getWifiInfoLocked();
                    if (wifiInfo != null) {
                        return wifiInfo.getSSID();
                    }
                    return "";
                }
            }
            return AndroidNetworkLibrary.getWifiSSID();
        }

        @GuardedBy(value="mLock")
        private WifiInfo getWifiInfoLocked() {
            try {
                return this.mWifiManager.getConnectionInfo();
            }
            catch (NullPointerException firstException) {
                try {
                    return this.mWifiManager.getConnectionInfo();
                }
                catch (NullPointerException secondException) {
                    return null;
                }
            }
        }
    }

    private class MyNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private Network mVpnInPlace;

        private MyNetworkCallback() {
        }

        void initializeVpnInPlace() {
            NetworkCapabilities capabilities;
            Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, null);
            this.mVpnInPlace = null;
            if (networks.length == 1 && (capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(networks[0])) != null && capabilities.hasTransport(4)) {
                this.mVpnInPlace = networks[0];
            }
        }

        private boolean ignoreNetworkDueToVpn(Network network) {
            return this.mVpnInPlace != null && !this.mVpnInPlace.equals((Object)network);
        }

        private boolean ignoreConnectedInaccessibleVpn(Network network, NetworkCapabilities capabilities) {
            if (capabilities == null) {
                capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
            }
            return capabilities == null || capabilities.hasTransport(4) && !NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.vpnAccessible(network);
        }

        private boolean ignoreConnectedNetwork(Network network, NetworkCapabilities capabilities) {
            return this.ignoreNetworkDueToVpn(network) || this.ignoreConnectedInaccessibleVpn(network, capabilities);
        }

        public void onAvailable(Network network) {
            try (TraceEvent e = TraceEvent.scoped("NetworkChangeNotifierCallback::onAvailable");){
                boolean makeVpnDefault;
                NetworkCapabilities capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
                if (this.ignoreConnectedNetwork(network, capabilities)) {
                    return;
                }
                boolean bl = makeVpnDefault = capabilities.hasTransport(4) && (this.mVpnInPlace == null || !network.equals((Object)this.mVpnInPlace));
                if (makeVpnDefault) {
                    this.mVpnInPlace = network;
                }
                final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
                final int connectionType = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getConnectionType(network);
                NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                        if (makeVpnDefault) {
                            NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(connectionType);
                            NetworkChangeNotifierAutoDetect.this.mObserver.purgeActiveNetworkList(new long[]{netId});
                        }
                    }
                });
            }
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            try (TraceEvent e = TraceEvent.scoped("NetworkChangeNotifierCallback::onCapabilitiesChanged");){
                if (this.ignoreConnectedNetwork(network, networkCapabilities)) {
                    return;
                }
                final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
                final int connectionType = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getConnectionType(network);
                NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                    }
                });
            }
        }

        public void onLosing(Network network, int maxMsToLive) {
            try (TraceEvent e = TraceEvent.scoped("NetworkChangeNotifierCallback::onLosing");){
                if (this.ignoreConnectedNetwork(network, null)) {
                    return;
                }
                final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
                NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkSoonToDisconnect(netId);
                    }
                });
            }
        }

        public void onLost(final Network network) {
            try (TraceEvent e = TraceEvent.scoped("NetworkChangeNotifierCallback::onLost");){
                if (this.ignoreNetworkDueToVpn(network)) {
                    return;
                }
                NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkDisconnect(NetworkChangeNotifierAutoDetect.networkToNetId(network));
                    }
                });
                if (this.mVpnInPlace != null) {
                    assert (network.equals((Object)this.mVpnInPlace));
                    this.mVpnInPlace = null;
                    for (Network newNetwork : NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, network)) {
                        this.onAvailable(newNetwork);
                    }
                    final int newConnectionType = NetworkChangeNotifierAutoDetect.this.getCurrentNetworkState().getConnectionType();
                    NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                        @Override
                        public void run() {
                            NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(newConnectionType);
                        }
                    });
                }
            }
        }
    }

    @RequiresApi(value=28)
    private class AndroidRDefaultNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        LinkProperties mLinkProperties;
        NetworkCapabilities mNetworkCapabilities;

        private AndroidRDefaultNetworkCallback() {
        }

        public void onAvailable(Network network) {
            this.mLinkProperties = null;
            this.mNetworkCapabilities = null;
        }

        public void onLost(Network network) {
            this.mLinkProperties = null;
            this.mNetworkCapabilities = null;
            if (NetworkChangeNotifierAutoDetect.this.mRegistered) {
                NetworkChangeNotifierAutoDetect.this.connectionTypeChangedTo(new NetworkState(false, -1, -1, false, null, false, ""));
            }
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            this.mLinkProperties = linkProperties;
            if (NetworkChangeNotifierAutoDetect.this.mRegistered && this.mLinkProperties != null && this.mNetworkCapabilities != null) {
                NetworkChangeNotifierAutoDetect.this.connectionTypeChangedTo(this.getNetworkState(network));
            }
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            this.mNetworkCapabilities = networkCapabilities;
            if (NetworkChangeNotifierAutoDetect.this.mRegistered && this.mLinkProperties != null && this.mNetworkCapabilities != null) {
                NetworkChangeNotifierAutoDetect.this.connectionTypeChangedTo(this.getNetworkState(network));
            }
        }

        private NetworkState getNetworkState(Network network) {
            NetworkInfo networkInfo;
            int type = -1;
            int subtype = -1;
            if (this.mNetworkCapabilities.hasTransport(1) || this.mNetworkCapabilities.hasTransport(5)) {
                type = 1;
            } else if (this.mNetworkCapabilities.hasTransport(0)) {
                type = 0;
                networkInfo = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getRawNetworkInfo(network);
                if (networkInfo != null) {
                    subtype = networkInfo.getSubtype();
                }
            } else if (this.mNetworkCapabilities.hasTransport(3)) {
                type = 9;
            } else if (this.mNetworkCapabilities.hasTransport(2)) {
                type = 7;
            } else if (this.mNetworkCapabilities.hasTransport(4)) {
                networkInfo = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkInfo(network);
                type = networkInfo != null ? networkInfo.getType() : 17;
            }
            boolean isMetered = !this.mNetworkCapabilities.hasCapability(11);
            return new NetworkState(true, type, subtype, isMetered, String.valueOf(NetworkChangeNotifierAutoDetect.networkToNetId(network)), ApiHelperForP.isPrivateDnsActive(this.mLinkProperties), ApiHelperForP.getPrivateDnsServerName(this.mLinkProperties));
        }
    }

    private class DefaultNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private DefaultNetworkCallback() {
        }

        public void onAvailable(Network network) {
            if (NetworkChangeNotifierAutoDetect.this.mRegistered) {
                NetworkChangeNotifierAutoDetect.this.connectionTypeChanged();
            }
        }

        public void onLost(Network network) {
            this.onAvailable(null);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            this.onAvailable(null);
        }
    }

    public static class NetworkState {
        private final boolean mConnected;
        private final int mType;
        private final int mSubtype;
        private final boolean mIsMetered;
        private final String mNetworkIdentifier;
        private final boolean mIsPrivateDnsActive;
        private final String mPrivateDnsServerName;

        public NetworkState(boolean connected, int type, int subtype, boolean isMetered, String networkIdentifier, boolean isPrivateDnsActive, String privateDnsServerName) {
            this.mConnected = connected;
            this.mType = type;
            this.mSubtype = subtype;
            this.mIsMetered = isMetered;
            this.mNetworkIdentifier = networkIdentifier == null ? "" : networkIdentifier;
            this.mIsPrivateDnsActive = isPrivateDnsActive;
            this.mPrivateDnsServerName = privateDnsServerName == null ? "" : privateDnsServerName;
        }

        public boolean isConnected() {
            return this.mConnected;
        }

        public int getNetworkType() {
            return this.mType;
        }

        public boolean isMetered() {
            return this.mIsMetered;
        }

        public int getNetworkSubType() {
            return this.mSubtype;
        }

        public String getNetworkIdentifier() {
            return this.mNetworkIdentifier;
        }

        public int getConnectionType() {
            if (!this.isConnected()) {
                return 6;
            }
            return NetworkChangeNotifierAutoDetect.convertToConnectionType(this.getNetworkType(), this.getNetworkSubType());
        }

        public int getConnectionCost() {
            if (this.isMetered()) {
                return 2;
            }
            return 1;
        }

        public int getConnectionSubtype() {
            if (!this.isConnected()) {
                return 1;
            }
            switch (this.getNetworkType()) {
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    return 0;
                }
                case 0: 
                case 4: 
                case 5: {
                    switch (this.getNetworkSubType()) {
                        case 1: {
                            return 7;
                        }
                        case 2: {
                            return 8;
                        }
                        case 4: {
                            return 5;
                        }
                        case 7: {
                            return 6;
                        }
                        case 11: {
                            return 4;
                        }
                        case 3: {
                            return 9;
                        }
                        case 5: {
                            return 10;
                        }
                        case 6: {
                            return 11;
                        }
                        case 8: {
                            return 14;
                        }
                        case 9: {
                            return 15;
                        }
                        case 10: {
                            return 12;
                        }
                        case 12: {
                            return 13;
                        }
                        case 14: {
                            return 16;
                        }
                        case 15: {
                            return 17;
                        }
                        case 13: {
                            return 18;
                        }
                    }
                    return 0;
                }
            }
            return 0;
        }

        public boolean isPrivateDnsActive() {
            return this.mIsPrivateDnsActive;
        }

        public String getPrivateDnsServerName() {
            return this.mPrivateDnsServerName;
        }
    }

    private static class NetworkConnectivityIntentFilter
    extends IntentFilter {
        NetworkConnectivityIntentFilter() {
            this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        }
    }

    public static abstract class RegistrationPolicy {
        private NetworkChangeNotifierAutoDetect mNotifier;

        protected final void register() {
            assert (this.mNotifier != null);
            this.mNotifier.register();
        }

        protected final void unregister() {
            assert (this.mNotifier != null);
            this.mNotifier.unregister();
        }

        protected void init(NetworkChangeNotifierAutoDetect notifier) {
            this.mNotifier = notifier;
        }

        protected abstract void destroy();
    }
}

