/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import org.chromium.build.annotations.CheckDiscard;
import org.chromium.net.NetworkChangeNotifier;
import org.jni_zero.GEN_JNI;
import org.jni_zero.JniStaticTestMocker;
import org.jni_zero.NativeLibraryLoadedStatus;

@CheckDiscard(value="crbug.com/993421")
class NetworkChangeNotifierJni
implements NetworkChangeNotifier.Natives {
    private static NetworkChangeNotifier.Natives testInstance;
    public static final JniStaticTestMocker<NetworkChangeNotifier.Natives> TEST_HOOKS;

    NetworkChangeNotifierJni() {
    }

    @Override
    public void notifyConnectionCostChanged(long nativePtr, NetworkChangeNotifier caller, int newConnectionCost) {
        GEN_JNI.org_chromium_net_NetworkChangeNotifier_notifyConnectionCostChanged(nativePtr, caller, newConnectionCost);
    }

    @Override
    public void notifyConnectionTypeChanged(long nativePtr, NetworkChangeNotifier caller, int newConnectionType, long defaultNetId) {
        GEN_JNI.org_chromium_net_NetworkChangeNotifier_notifyConnectionTypeChanged(nativePtr, caller, newConnectionType, defaultNetId);
    }

    @Override
    public void notifyMaxBandwidthChanged(long nativePtr, NetworkChangeNotifier caller, int subType) {
        GEN_JNI.org_chromium_net_NetworkChangeNotifier_notifyMaxBandwidthChanged(nativePtr, caller, subType);
    }

    @Override
    public void notifyOfNetworkConnect(long nativePtr, NetworkChangeNotifier caller, long netId, int connectionType) {
        GEN_JNI.org_chromium_net_NetworkChangeNotifier_notifyOfNetworkConnect(nativePtr, caller, netId, connectionType);
    }

    @Override
    public void notifyOfNetworkDisconnect(long nativePtr, NetworkChangeNotifier caller, long netId) {
        GEN_JNI.org_chromium_net_NetworkChangeNotifier_notifyOfNetworkDisconnect(nativePtr, caller, netId);
    }

    @Override
    public void notifyOfNetworkSoonToDisconnect(long nativePtr, NetworkChangeNotifier caller, long netId) {
        GEN_JNI.org_chromium_net_NetworkChangeNotifier_notifyOfNetworkSoonToDisconnect(nativePtr, caller, netId);
    }

    @Override
    public void notifyPurgeActiveNetworkList(long nativePtr, NetworkChangeNotifier caller, long[] activeNetIds) {
        GEN_JNI.org_chromium_net_NetworkChangeNotifier_notifyPurgeActiveNetworkList(nativePtr, caller, activeNetIds);
    }

    public static NetworkChangeNotifier.Natives get() {
        if (GEN_JNI.TESTING_ENABLED) {
            if (testInstance != null) {
                return testInstance;
            }
            if (GEN_JNI.REQUIRE_MOCK) {
                throw new UnsupportedOperationException("No mock found for the native implementation of NetworkChangeNotifier.Natives. The current configuration requires implementations be mocked.");
            }
        }
        NativeLibraryLoadedStatus.checkLoaded();
        return new NetworkChangeNotifierJni();
    }

    static {
        TEST_HOOKS = new JniStaticTestMocker<NetworkChangeNotifier.Natives>(){

            @Override
            public void setInstanceForTesting(NetworkChangeNotifier.Natives instance) {
                if (!GEN_JNI.TESTING_ENABLED) {
                    throw new RuntimeException("Tried to set a JNI mock when mocks aren't enabled!");
                }
                testInstance = instance;
            }
        };
    }
}

