/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import androidx.annotation.VisibleForTesting;
import java.nio.charset.StandardCharsets;

public class NetworkTrafficAnnotationTag {
    public static final NetworkTrafficAnnotationTag NO_TRAFFIC_ANNOTATION_YET = NetworkTrafficAnnotationTag.createComplete("undefined", "Nothing here yet.");
    public static final NetworkTrafficAnnotationTag MISSING_TRAFFIC_ANNOTATION = NetworkTrafficAnnotationTag.createComplete("undefined", "Function called without traffic annotation.");
    public static final NetworkTrafficAnnotationTag TRAFFIC_ANNOTATION_FOR_TESTS = NetworkTrafficAnnotationTag.createComplete("test", "Traffic annotation for unit, browser and other tests");
    private final int mHashCode;

    public static NetworkTrafficAnnotationTag createComplete(String uniqueId, String proto) {
        return new NetworkTrafficAnnotationTag(uniqueId);
    }

    public int getHashCode() {
        return this.mHashCode;
    }

    private NetworkTrafficAnnotationTag(String uniqueId) {
        this.mHashCode = NetworkTrafficAnnotationTag.iterativeHash(uniqueId);
    }

    @VisibleForTesting
    static int iterativeHash(String s) {
        byte[] bytes;
        long acc = 0L;
        for (byte b : bytes = s.getBytes(StandardCharsets.UTF_8)) {
            acc = (acc * 31L + (long)b) % 138003713L;
        }
        return (int)acc;
    }
}

