/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.ResettersForTesting;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.build.BuildConfig;
import org.chromium.build.annotations.UsedByReflection;
import org.chromium.net.ProxyBroadcastReceiver;
import org.chromium.net.ProxyChangeListenerJni;

@JNINamespace(value="net")
@UsedByReflection(value="WebView embedders call this to override proxy settings")
public class ProxyChangeListener {
    private static final String TAG = "ProxyChangeListener";
    private static boolean sEnabled = true;
    private final Looper mLooper = Looper.myLooper();
    private final Handler mHandler = new Handler(this.mLooper);
    private long mNativePtr;
    private ProxyReceiver mProxyReceiver;
    private BroadcastReceiver mRealProxyReceiver;
    private Delegate mDelegate;

    private ProxyChangeListener() {
    }

    public static void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public void setDelegateForTesting(Delegate delegate) {
        Delegate oldValue = this.mDelegate;
        this.mDelegate = delegate;
        ResettersForTesting.register(() -> {
            this.mDelegate = oldValue;
        });
    }

    @CalledByNative
    public static ProxyChangeListener create() {
        return new ProxyChangeListener();
    }

    @CalledByNative
    public static String getProperty(String property) {
        return System.getProperty(property);
    }

    @CalledByNative
    public void start(long nativePtr) {
        try (TraceEvent e = TraceEvent.scoped("ProxyChangeListener.start");){
            this.assertOnThread();
            assert (this.mNativePtr == 0L);
            this.mNativePtr = nativePtr;
            this.registerBroadcastReceiver();
        }
    }

    @CalledByNative
    public void stop() {
        this.assertOnThread();
        this.mNativePtr = 0L;
        this.unregisterBroadcastReceiver();
    }

    private static ProxyConfig extractNewProxy(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return ProxyConfig.fromProxyInfo((ProxyInfo)extras.get("android.intent.extra.PROXY_INFO"));
        }
        try {
            Method getPacFileUrlMethod;
            String pacFileUrl;
            String getHostName = "getHost";
            String getPortName = "getPort";
            String getPacFileUrl = "getPacFileUrl";
            String getExclusionList = "getExclusionList";
            String className = "android.net.ProxyProperties";
            Object props = extras.get("proxy");
            if (props == null) {
                return null;
            }
            Class<?> cls = Class.forName("android.net.ProxyProperties");
            Method getHostMethod = cls.getDeclaredMethod("getHost", new Class[0]);
            Method getPortMethod = cls.getDeclaredMethod("getPort", new Class[0]);
            Method getExclusionListMethod = cls.getDeclaredMethod("getExclusionList", new Class[0]);
            String host = (String)getHostMethod.invoke(props, new Object[0]);
            int port = (Integer)getPortMethod.invoke(props, new Object[0]);
            String s = (String)getExclusionListMethod.invoke(props, new Object[0]);
            String[] exclusionList = s.split(",");
            if (Build.VERSION.SDK_INT >= 19 && !TextUtils.isEmpty((CharSequence)(pacFileUrl = (String)(getPacFileUrlMethod = cls.getDeclaredMethod("getPacFileUrl", new Class[0])).invoke(props, new Object[0])))) {
                return new ProxyConfig(host, port, pacFileUrl, exclusionList);
            }
            return new ProxyConfig(host, port, null, exclusionList);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException ex) {
            Log.e(TAG, "Using no proxy configuration due to exception:" + ex);
            return null;
        }
    }

    private void proxySettingsChanged(ProxyConfig cfg) {
        this.assertOnThread();
        if (!sEnabled) {
            return;
        }
        if (this.mDelegate != null) {
            this.mDelegate.proxySettingsChanged();
        }
        if (this.mNativePtr == 0L) {
            return;
        }
        if (cfg != null) {
            ProxyChangeListenerJni.get().proxySettingsChangedTo(this.mNativePtr, this, cfg.mHost, cfg.mPort, cfg.mPacUrl, cfg.mExclusionList);
        } else {
            ProxyChangeListenerJni.get().proxySettingsChanged(this.mNativePtr, this);
        }
    }

    @RequiresApi(value=23)
    private ProxyConfig getProxyConfig(Intent intent) {
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        ProxyConfig configFromConnectivityManager = ProxyConfig.fromProxyInfo(connectivityManager.getDefaultProxy());
        if (configFromConnectivityManager == null) {
            return ProxyConfig.DIRECT;
        }
        if (Build.VERSION.SDK_INT >= 29 && configFromConnectivityManager.mHost.equals("localhost") && configFromConnectivityManager.mPort == -1) {
            ProxyConfig configFromIntent = ProxyChangeListener.extractNewProxy(intent);
            Log.i(TAG, "configFromConnectivityManager = %s, configFromIntent = %s", (Object)configFromConnectivityManager, (Object)configFromIntent);
            if (configFromIntent == null) {
                return null;
            }
            String correctHost = configFromIntent.mHost;
            int correctPort = configFromIntent.mPort;
            return new ProxyConfig(correctHost, correctPort, configFromConnectivityManager.mPacUrl, configFromConnectivityManager.mExclusionList);
        }
        return configFromConnectivityManager;
    }

    void updateProxyConfigFromConnectivityManager(Intent intent) {
        this.runOnThread(() -> this.proxySettingsChanged(this.getProxyConfig(intent)));
    }

    private void registerBroadcastReceiver() {
        this.assertOnThread();
        assert (this.mProxyReceiver == null);
        assert (this.mRealProxyReceiver == null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PROXY_CHANGE");
        this.mProxyReceiver = new ProxyReceiver();
        if (Build.VERSION.SDK_INT < 23) {
            ContextUtils.registerProtectedBroadcastReceiver(ContextUtils.getApplicationContext(), this.mProxyReceiver, filter);
        } else {
            if (!ContextUtils.isSdkSandboxProcess()) {
                ContextUtils.registerNonExportedBroadcastReceiver(ContextUtils.getApplicationContext(), this.mProxyReceiver, new IntentFilter());
            }
            this.mRealProxyReceiver = new ProxyBroadcastReceiver(this);
            ContextUtils.registerProtectedBroadcastReceiver(ContextUtils.getApplicationContext(), this.mRealProxyReceiver, filter);
        }
    }

    private void unregisterBroadcastReceiver() {
        this.assertOnThread();
        assert (this.mProxyReceiver != null);
        ContextUtils.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mProxyReceiver);
        if (this.mRealProxyReceiver != null) {
            ContextUtils.getApplicationContext().unregisterReceiver(this.mRealProxyReceiver);
        }
        this.mProxyReceiver = null;
        this.mRealProxyReceiver = null;
    }

    private boolean onThread() {
        return this.mLooper == Looper.myLooper();
    }

    private void assertOnThread() {
        if (BuildConfig.ENABLE_ASSERTS && !this.onThread()) {
            throw new IllegalStateException("Must be called on ProxyChangeListener thread.");
        }
    }

    private void runOnThread(Runnable r) {
        if (this.onThread()) {
            r.run();
        } else {
            this.mHandler.post(r);
        }
    }

    public static interface Delegate {
        public void proxySettingsChanged();
    }

    private static class ProxyConfig {
        public final String mHost;
        public final int mPort;
        public final String mPacUrl;
        public final String[] mExclusionList;
        public static final ProxyConfig DIRECT = new ProxyConfig("", 0, "", new String[0]);

        public ProxyConfig(String host, int port, String pacUrl, String[] exclusionList) {
            this.mHost = host;
            this.mPort = port;
            this.mPacUrl = pacUrl;
            this.mExclusionList = exclusionList;
        }

        private static ProxyConfig fromProxyInfo(ProxyInfo proxyInfo) {
            if (proxyInfo == null) {
                return null;
            }
            String host = proxyInfo.getHost();
            Uri pacFileUrl = proxyInfo.getPacFileUrl();
            return new ProxyConfig(host == null ? "" : host, proxyInfo.getPort(), Uri.EMPTY.equals((Object)pacFileUrl) ? null : pacFileUrl.toString(), proxyInfo.getExclusionList());
        }

        public String toString() {
            String possiblyRedactedHost = this.mHost.equals("localhost") || this.mHost.isEmpty() ? this.mHost : "<redacted>";
            return String.format(Locale.US, "ProxyConfig [mHost=\"%s\", mPort=%d, mPacUrl=%s]", possiblyRedactedHost, this.mPort, this.mPacUrl == null ? "null" : "\"<redacted>\"");
        }
    }

    static interface Natives {
        @NativeClassQualifiedName(value="ProxyConfigServiceAndroid::JNIDelegate")
        public void proxySettingsChangedTo(long var1, ProxyChangeListener var3, String var4, int var5, String var6, String[] var7);

        @NativeClassQualifiedName(value="ProxyConfigServiceAndroid::JNIDelegate")
        public void proxySettingsChanged(long var1, ProxyChangeListener var3);
    }

    @UsedByReflection(value="WebView embedders call this to override proxy settings")
    private class ProxyReceiver
    extends BroadcastReceiver {
        private ProxyReceiver() {
        }

        @UsedByReflection(value="WebView embedders call this to override proxy settings")
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
                ProxyChangeListener.this.runOnThread(() -> ProxyChangeListener.this.proxySettingsChanged(ProxyChangeListener.extractNewProxy(intent)));
            }
        }
    }
}

