/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.httpflags;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.chromium.base.Log;
import org.chromium.net.httpflags.Flags;
import org.chromium.net.impl.CronetManifest;

public final class HttpFlagsLoader {
    @VisibleForTesting
    static final String FLAGS_FILE_PROVIDER_INTENT_ACTION = "android.net.http.FLAGS_FILE_PROVIDER";
    @VisibleForTesting
    static final String FLAGS_FILE_DIR_NAME = "app_httpflags";
    @VisibleForTesting
    static final String FLAGS_FILE_NAME = "flags.binarypb";
    private static final String TAG = "HttpFlagsLoader";

    private HttpFlagsLoader() {
    }

    @Nullable
    public static Flags load(Context context) {
        if (!CronetManifest.shouldReadHttpFlags((Context)context)) {
            Log.d(TAG, "Not loading HTTP flags because they are disabled in the manifest", new Object[0]);
            return null;
        }
        try {
            ApplicationInfo providerApplicationInfo = HttpFlagsLoader.getProviderApplicationInfo(context);
            if (providerApplicationInfo == null) {
                return null;
            }
            Log.d(TAG, "Found application exporting HTTP flags: %s", providerApplicationInfo.packageName);
            File flagsFile = HttpFlagsLoader.getFlagsFileFromProvider(context, providerApplicationInfo);
            Log.d(TAG, "HTTP flags file path: %s", flagsFile.getAbsolutePath());
            Flags flags = HttpFlagsLoader.loadFlagsFile(flagsFile);
            if (flags == null) {
                return null;
            }
            Log.d(TAG, "Successfully loaded HTTP flags: %s", flags);
            return flags;
        }
        catch (RuntimeException exception) {
            Log.e(TAG, "Unable to load HTTP flags file", exception);
            return null;
        }
    }

    @Nullable
    private static ApplicationInfo getProviderApplicationInfo(Context context) {
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(new Intent(FLAGS_FILE_PROVIDER_INTENT_ACTION), 0x100000);
        if (resolveInfo == null) {
            Log.w(TAG, "Unable to resolve the HTTP flags file provider package. This is expected if the host system is not set up to provide HTTP flags.");
            return null;
        }
        return resolveInfo.serviceInfo.applicationInfo;
    }

    private static File getFlagsFileFromProvider(Context context, ApplicationInfo providerApplicationInfo) {
        return new File(new File(new File(Build.VERSION.SDK_INT >= 24 ? providerApplicationInfo.deviceProtectedDataDir : providerApplicationInfo.dataDir), FLAGS_FILE_DIR_NAME), FLAGS_FILE_NAME);
    }

    @Nullable
    private static Flags loadFlagsFile(File file) {
        Flags flags;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            flags = Flags.parseDelimitedFrom(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException exception) {
                Log.w(TAG, "HTTP flags file `%s` is missing. This is expected if HTTP flags functionality is currently disabled in the host system.", (Object)file.getPath());
                return null;
            }
            catch (IOException exception) {
                throw new RuntimeException("Unable to read HTTP flags file", exception);
            }
        }
        fileInputStream.close();
        return flags;
    }
}

