/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.net.CronetException;
import org.chromium.net.InlineExecutionProhibitedException;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.impl.CallbackExceptionImpl;
import org.chromium.net.impl.CronetExceptionImpl;
import org.chromium.net.impl.CronetLogger;
import org.chromium.net.impl.CronetMetrics;
import org.chromium.net.impl.CronetUploadDataStream;
import org.chromium.net.impl.CronetUrlRequestContext;
import org.chromium.net.impl.CronetUrlRequestJni;
import org.chromium.net.impl.NetworkExceptionImpl;
import org.chromium.net.impl.Preconditions;
import org.chromium.net.impl.QuicExceptionImpl;
import org.chromium.net.impl.RefCountDelegate;
import org.chromium.net.impl.RequestFinishedInfoImpl;
import org.chromium.net.impl.UrlRequestBase;
import org.chromium.net.impl.UrlResponseInfoImpl;
import org.chromium.net.impl.VersionSafeCallbacks;

@JNINamespace(value="cronet")
@VisibleForTesting
public final class CronetUrlRequest
extends UrlRequestBase {
    private final boolean mAllowDirectExecutor;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private long mUrlRequestAdapter;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mStarted;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mWaitingOnRedirect;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mWaitingOnRead;
    private final Object mUrlRequestAdapterLock = new Object();
    private final CronetUrlRequestContext mRequestContext;
    private final Executor mExecutor;
    private final List<String> mUrlChain = new ArrayList<String>();
    private final VersionSafeCallbacks.UrlRequestCallback mCallback;
    private final String mInitialUrl;
    private final int mPriority;
    private final int mIdempotency;
    private String mInitialMethod;
    private final HeadersList mRequestHeaders = new HeadersList();
    private final Collection<Object> mRequestAnnotations;
    private final boolean mDisableCache;
    private final boolean mDisableConnectionMigration;
    private final boolean mTrafficStatsTagSet;
    private final int mTrafficStatsTag;
    private final boolean mTrafficStatsUidSet;
    private final int mTrafficStatsUid;
    private final VersionSafeCallbacks.RequestFinishedInfoListener mRequestFinishedListener;
    private final long mNetworkHandle;
    private final int mCronetEngineId;
    private final CronetLogger mLogger;
    private CronetUploadDataStream mUploadDataStream;
    private UrlResponseInfoImpl mResponseInfo;
    private int mFinishedReason;
    private CronetException mException;
    private CronetMetrics mMetrics;
    private boolean mQuicConnectionMigrationAttempted;
    private boolean mQuicConnectionMigrationSuccessful;
    private OnReadCompletedRunnable mOnReadCompletedTask;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private Runnable mOnDestroyedCallbackForTesting;

    CronetUrlRequest(CronetUrlRequestContext requestContext, String url, int priority, UrlRequest.Callback callback, Executor executor, Collection<Object> requestAnnotations, boolean disableCache, boolean disableConnectionMigration, boolean allowDirectExecutor, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, RequestFinishedInfo.Listener requestFinishedListener, int idempotency, long networkHandle) {
        Objects.requireNonNull(url, "URL is required");
        Objects.requireNonNull(callback, "Listener is required");
        Objects.requireNonNull(executor, "Executor is required");
        this.mAllowDirectExecutor = allowDirectExecutor;
        this.mRequestContext = requestContext;
        this.mCronetEngineId = requestContext.getCronetEngineId();
        this.mLogger = requestContext.getCronetLogger();
        this.mInitialUrl = url;
        this.mUrlChain.add(url);
        this.mPriority = CronetUrlRequest.convertRequestPriority(priority);
        this.mCallback = new VersionSafeCallbacks.UrlRequestCallback(callback);
        this.mExecutor = executor;
        this.mRequestAnnotations = requestAnnotations;
        this.mDisableCache = disableCache;
        this.mDisableConnectionMigration = disableConnectionMigration;
        this.mTrafficStatsTagSet = trafficStatsTagSet;
        this.mTrafficStatsTag = trafficStatsTag;
        this.mTrafficStatsUidSet = trafficStatsUidSet;
        this.mTrafficStatsUid = trafficStatsUid;
        this.mRequestFinishedListener = requestFinishedListener != null ? new VersionSafeCallbacks.RequestFinishedInfoListener(requestFinishedListener) : null;
        this.mIdempotency = CronetUrlRequest.convertIdempotency(idempotency);
        this.mNetworkHandle = networkHandle;
    }

    public void setHttpMethod(String method) {
        this.checkNotStarted();
        Objects.requireNonNull(method, "Method is required.");
        this.mInitialMethod = method;
    }

    public void addHeader(String header, String value) {
        this.checkNotStarted();
        Objects.requireNonNull(header, "Invalid header name.");
        Objects.requireNonNull(value, "Invalid header value.");
        this.mRequestHeaders.add(new AbstractMap.SimpleImmutableEntry<String, String>(header, value));
    }

    public void setUploadDataProvider(UploadDataProvider uploadDataProvider, Executor executor) {
        Objects.requireNonNull(uploadDataProvider, "Invalid UploadDataProvider.");
        if (this.mInitialMethod == null) {
            this.mInitialMethod = "POST";
        }
        this.mUploadDataStream = new CronetUploadDataStream(uploadDataProvider, executor, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            this.checkNotStarted();
            try {
                this.mUrlRequestAdapter = CronetUrlRequestJni.get().createRequestAdapter(this, this.mRequestContext.getUrlRequestContextAdapter(), this.mInitialUrl, this.mPriority, this.mDisableCache, this.mDisableConnectionMigration, this.mTrafficStatsTagSet, this.mTrafficStatsTag, this.mTrafficStatsUidSet, this.mTrafficStatsUid, this.mIdempotency, this.mNetworkHandle);
                this.mRequestContext.onRequestStarted();
                if (this.mInitialMethod != null && !CronetUrlRequestJni.get().setHttpMethod(this.mUrlRequestAdapter, this, this.mInitialMethod)) {
                    throw new IllegalArgumentException("Invalid http method " + this.mInitialMethod);
                }
                boolean hasContentType = false;
                for (Map.Entry header : this.mRequestHeaders) {
                    if (((String)header.getKey()).equalsIgnoreCase("Content-Type") && !((String)header.getValue()).isEmpty()) {
                        hasContentType = true;
                    }
                    if (CronetUrlRequestJni.get().addRequestHeader(this.mUrlRequestAdapter, this, (String)header.getKey(), (String)header.getValue())) continue;
                    throw new IllegalArgumentException("Invalid header " + (String)header.getKey() + "=" + (String)header.getValue());
                }
                if (this.mUploadDataStream != null) {
                    if (!hasContentType) {
                        throw new IllegalArgumentException("Requests with upload data must have a Content-Type.");
                    }
                    this.mStarted = true;
                    this.mUploadDataStream.postTaskToExecutor(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            CronetUrlRequest.this.mUploadDataStream.initializeWithRequest();
                            Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                            synchronized (object) {
                                if (CronetUrlRequest.this.isDoneLocked()) {
                                    return;
                                }
                                CronetUrlRequest.this.mUploadDataStream.attachNativeAdapterToRequest(CronetUrlRequest.this.mUrlRequestAdapter);
                                CronetUrlRequest.this.startInternalLocked();
                            }
                        }
                    });
                    return;
                }
            }
            catch (RuntimeException e) {
                this.destroyRequestAdapterLocked(1);
                this.mRequestContext.onRequestFinished();
                throw e;
            }
            this.mStarted = true;
            this.startInternalLocked();
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private void startInternalLocked() {
        CronetUrlRequestJni.get().start(this.mUrlRequestAdapter, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void followRedirect() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (!this.mWaitingOnRedirect) {
                throw new IllegalStateException("No redirect to follow.");
            }
            this.mWaitingOnRedirect = false;
            if (this.isDoneLocked()) {
                return;
            }
            CronetUrlRequestJni.get().followDeferredRedirect(this.mUrlRequestAdapter, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ByteBuffer buffer) {
        Preconditions.checkHasRemaining((ByteBuffer)buffer);
        Preconditions.checkDirect((ByteBuffer)buffer);
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (!this.mWaitingOnRead) {
                throw new IllegalStateException("Unexpected read attempt.");
            }
            this.mWaitingOnRead = false;
            if (this.isDoneLocked()) {
                return;
            }
            if (!CronetUrlRequestJni.get().readData(this.mUrlRequestAdapter, this, buffer, buffer.position(), buffer.limit())) {
                this.mWaitingOnRead = true;
                throw new IllegalArgumentException("Unable to call native read");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.isDoneLocked() || !this.mStarted) {
                return;
            }
            this.destroyRequestAdapterLocked(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            return this.isDoneLocked();
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean isDoneLocked() {
        return this.mStarted && this.mUrlRequestAdapter == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStatus(UrlRequest.StatusListener unsafeListener) {
        final VersionSafeCallbacks.UrlRequestStatusListener listener = new VersionSafeCallbacks.UrlRequestStatusListener(unsafeListener);
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mUrlRequestAdapter != 0L) {
                CronetUrlRequestJni.get().getStatus(this.mUrlRequestAdapter, this, listener);
                return;
            }
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                listener.onStatus(-1);
            }
        };
        this.postTaskToExecutor(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDestroyedCallbackForTesting(Runnable onDestroyedCallbackForTesting) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            this.mOnDestroyedCallbackForTesting = onDestroyedCallbackForTesting;
        }
    }

    public void setOnDestroyedUploadCallbackForTesting(Runnable onDestroyedUploadCallbackForTesting) {
        this.mUploadDataStream.setOnDestroyedCallbackForTesting(onDestroyedUploadCallbackForTesting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUrlRequestAdapterForTesting() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            return this.mUrlRequestAdapter;
        }
    }

    private void postTaskToExecutor(Runnable task) {
        try {
            this.mExecutor.execute(task);
        }
        catch (RejectedExecutionException failException) {
            Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", failException);
            this.failWithException((CronetException)new CronetExceptionImpl("Exception posting task to executor", (Throwable)failException));
        }
    }

    private static int convertRequestPriority(int priority) {
        switch (priority) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 4;
    }

    private static int convertIdempotency(int idempotency) {
        switch (idempotency) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    @VisibleForTesting
    static long estimateHeadersSizeInBytes(Map<String, List<String>> headers) {
        if (headers == null) {
            return 0L;
        }
        long responseHeaderSizeInBytes = 0L;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key != null) {
                responseHeaderSizeInBytes += (long)key.length();
            }
            if (entry.getValue() == null) continue;
            for (String content : entry.getValue()) {
                responseHeaderSizeInBytes += (long)content.length();
            }
        }
        return responseHeaderSizeInBytes;
    }

    @VisibleForTesting
    static long estimateHeadersSizeInBytes(HeadersList headers) {
        if (headers == null) {
            return 0L;
        }
        long responseHeaderSizeInBytes = 0L;
        for (Map.Entry entry : headers) {
            String value;
            String key = (String)entry.getKey();
            if (key != null) {
                responseHeaderSizeInBytes += (long)key.length();
            }
            if ((value = (String)entry.getValue()) == null) continue;
            responseHeaderSizeInBytes += (long)((String)entry.getValue()).length();
        }
        return responseHeaderSizeInBytes;
    }

    private UrlResponseInfoImpl prepareResponseInfoOnNetworkThread(int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        HeadersList headersList = new HeadersList();
        for (int i = 0; i < headers.length; i += 2) {
            headersList.add(new AbstractMap.SimpleImmutableEntry<String, String>(headers[i], headers[i + 1]));
        }
        return new UrlResponseInfoImpl(new ArrayList<String>(this.mUrlChain), httpStatusCode, httpStatusText, (List)headersList, wasCached, negotiatedProtocol, proxyServer, receivedByteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotStarted() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mStarted || this.isDoneLocked()) {
                throw new IllegalStateException("Request is already started.");
            }
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private void destroyRequestAdapterLocked(int finishedReason) {
        assert (this.mException == null || finishedReason == 1);
        this.mFinishedReason = finishedReason;
        if (this.mUrlRequestAdapter == 0L) {
            return;
        }
        this.mRequestContext.onRequestDestroyed();
        CronetUrlRequestJni.get().destroy(this.mUrlRequestAdapter, this, finishedReason == 2);
        this.mUrlRequestAdapter = 0L;
    }

    private void onCallbackException(Exception e) {
        CallbackExceptionImpl requestError = new CallbackExceptionImpl("Exception received from UrlRequest.Callback", (Throwable)e);
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in CalledByNative method", e);
        this.failWithException((CronetException)requestError);
    }

    void onUploadException(Throwable e) {
        CallbackExceptionImpl uploadError = new CallbackExceptionImpl("Exception received from UploadDataProvider", e);
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in upload method", e);
        this.failWithException((CronetException)uploadError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failWithException(CronetException exception) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.isDoneLocked()) {
                return;
            }
            assert (this.mException == null);
            this.mException = exception;
            this.destroyRequestAdapterLocked(1);
        }
    }

    @CalledByNative
    private void onRedirectReceived(final String newLocation, int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        final UrlResponseInfoImpl responseInfo = this.prepareResponseInfoOnNetworkThread(httpStatusCode, httpStatusText, headers, wasCached, negotiatedProtocol, proxyServer, receivedByteCount);
        this.mUrlChain.add(newLocation);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CronetUrlRequest.this.checkCallingThread();
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRedirect = true;
                }
                try {
                    CronetUrlRequest.this.mCallback.onRedirectReceived((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)responseInfo, newLocation);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onCallbackException(e);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onResponseStarted(int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        this.mResponseInfo = this.prepareResponseInfoOnNetworkThread(httpStatusCode, httpStatusText, headers, wasCached, negotiatedProtocol, proxyServer, receivedByteCount);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CronetUrlRequest.this.checkCallingThread();
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRead = true;
                }
                try {
                    CronetUrlRequest.this.mCallback.onResponseStarted((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onCallbackException(e);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onReadCompleted(ByteBuffer byteBuffer, int bytesRead, int initialPosition, int initialLimit, long receivedByteCount) {
        this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        if (byteBuffer.position() != initialPosition || byteBuffer.limit() != initialLimit) {
            this.failWithException((CronetException)new CronetExceptionImpl("ByteBuffer modified externally during read", null));
            return;
        }
        if (this.mOnReadCompletedTask == null) {
            this.mOnReadCompletedTask = new OnReadCompletedRunnable();
        }
        byteBuffer.position(initialPosition + bytesRead);
        this.mOnReadCompletedTask.mByteBuffer = byteBuffer;
        this.postTaskToExecutor(this.mOnReadCompletedTask);
    }

    @CalledByNative
    private void onSucceeded(long receivedByteCount) {
        this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.destroyRequestAdapterLocked(0);
                }
                try {
                    CronetUrlRequest.this.mCallback.onSucceeded((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo);
                }
                catch (Exception e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onSucceeded method", e);
                }
                CronetUrlRequest.this.maybeReportMetrics();
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onError(int errorCode, int nativeError, int nativeQuicError, String errorString, long receivedByteCount) {
        if (this.mResponseInfo != null) {
            this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        }
        if (errorCode == 10 || errorCode == 3) {
            this.failWithException((CronetException)new QuicExceptionImpl("Exception in CronetUrlRequest: " + errorString, errorCode, nativeError, nativeQuicError));
        } else {
            int javaError = this.mapUrlRequestErrorToApiErrorCode(errorCode);
            this.failWithException((CronetException)new NetworkExceptionImpl("Exception in CronetUrlRequest: " + errorString, javaError, nativeError));
        }
    }

    @CalledByNative
    private void onCanceled() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CronetUrlRequest.this.mCallback.onCanceled((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo);
                }
                catch (Exception e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onCanceled method", e);
                }
                CronetUrlRequest.this.maybeReportMetrics();
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onStatus(final VersionSafeCallbacks.UrlRequestStatusListener listener, final int loadState) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                listener.onStatus(UrlRequestBase.convertLoadState((int)loadState));
            }
        };
        this.postTaskToExecutor(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onMetricsCollected(long requestStartMs, long dnsStartMs, long dnsEndMs, long connectStartMs, long connectEndMs, long sslStartMs, long sslEndMs, long sendingStartMs, long sendingEndMs, long pushStartMs, long pushEndMs, long responseStartMs, long requestEndMs, boolean socketReused, long sentByteCount, long receivedByteCount, boolean quicConnectionMigrationAttempted, boolean quicConnectionMigrationSuccessful) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mMetrics != null) {
                throw new IllegalStateException("Metrics collection should only happen once.");
            }
            this.mMetrics = new CronetMetrics(requestStartMs, dnsStartMs, dnsEndMs, connectStartMs, connectEndMs, sslStartMs, sslEndMs, sendingStartMs, sendingEndMs, pushStartMs, pushEndMs, responseStartMs, requestEndMs, socketReused, sentByteCount, receivedByteCount);
            this.mQuicConnectionMigrationAttempted = quicConnectionMigrationAttempted;
            this.mQuicConnectionMigrationSuccessful = quicConnectionMigrationSuccessful;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onNativeAdapterDestroyed() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mOnDestroyedCallbackForTesting != null) {
                this.mOnDestroyedCallbackForTesting.run();
            }
            if (this.mException == null) {
                return;
            }
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CronetUrlRequest.this.mCallback.onFailed((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo, CronetUrlRequest.this.mException);
                }
                catch (Exception e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onFailed method", e);
                }
                CronetUrlRequest.this.maybeReportMetrics();
            }
        };
        try {
            this.mExecutor.execute(task);
        }
        catch (RejectedExecutionException e) {
            Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", e);
        }
    }

    void checkCallingThread() {
        if (!this.mAllowDirectExecutor && this.mRequestContext.isNetworkThread(Thread.currentThread())) {
            throw new InlineExecutionProhibitedException();
        }
    }

    private int mapUrlRequestErrorToApiErrorCode(int errorCode) {
        switch (errorCode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
        }
        Log.e(CronetUrlRequestContext.LOG_TAG, "Unknown error code: " + errorCode);
        return errorCode;
    }

    @RequiresApi(value=26)
    private CronetLogger.CronetTrafficInfo buildCronetTrafficInfo() {
        long responseHeaderSizeInBytes;
        long responseBodySizeInBytes;
        long requestBodySizeInBytes;
        long requestHeaderSizeInBytes;
        boolean wasCached;
        int httpStatusCode;
        String negotiatedProtocol;
        Map responseHeaders;
        assert (this.mMetrics != null);
        assert (this.mRequestHeaders != null);
        if (this.mResponseInfo != null) {
            responseHeaders = this.mResponseInfo.getAllHeaders();
            negotiatedProtocol = this.mResponseInfo.getNegotiatedProtocol();
            httpStatusCode = this.mResponseInfo.getHttpStatusCode();
            wasCached = this.mResponseInfo.wasCached();
        } else {
            responseHeaders = Collections.emptyMap();
            negotiatedProtocol = "";
            httpStatusCode = 0;
            wasCached = false;
        }
        long requestTotalSizeInBytes = this.mMetrics.getSentByteCount();
        if (wasCached && requestTotalSizeInBytes == 0L) {
            requestHeaderSizeInBytes = 0L;
            requestBodySizeInBytes = 0L;
        } else {
            requestHeaderSizeInBytes = CronetUrlRequest.estimateHeadersSizeInBytes(this.mRequestHeaders);
            requestBodySizeInBytes = Math.max(0L, requestTotalSizeInBytes - requestHeaderSizeInBytes);
        }
        long responseTotalSizeInBytes = this.mMetrics.getReceivedByteCount();
        if (wasCached && responseTotalSizeInBytes == 0L) {
            responseBodySizeInBytes = 0L;
            responseHeaderSizeInBytes = 0L;
        } else {
            responseHeaderSizeInBytes = CronetUrlRequest.estimateHeadersSizeInBytes(responseHeaders);
            responseBodySizeInBytes = Math.max(0L, responseTotalSizeInBytes - responseHeaderSizeInBytes);
        }
        Duration headersLatency = this.mMetrics.getRequestStart() != null && this.mMetrics.getResponseStart() != null ? Duration.ofMillis(this.mMetrics.getResponseStart().getTime() - this.mMetrics.getRequestStart().getTime()) : Duration.ofSeconds(0L);
        Duration totalLatency = this.mMetrics.getRequestStart() != null && this.mMetrics.getRequestEnd() != null ? Duration.ofMillis(this.mMetrics.getRequestEnd().getTime() - this.mMetrics.getRequestStart().getTime()) : Duration.ofSeconds(0L);
        return new CronetLogger.CronetTrafficInfo(requestHeaderSizeInBytes, requestBodySizeInBytes, responseHeaderSizeInBytes, responseBodySizeInBytes, httpStatusCode, headersLatency, totalLatency, negotiatedProtocol, this.mQuicConnectionMigrationAttempted, this.mQuicConnectionMigrationSuccessful);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReportMetrics() {
        RefCountDelegate inflightCallbackCount = new RefCountDelegate(() -> this.mRequestContext.onRequestFinished());
        try {
            if (this.mMetrics == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                try {
                    this.mLogger.logCronetTrafficInfo(this.mCronetEngineId, this.buildCronetTrafficInfo());
                }
                catch (RuntimeException e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Error while trying to log CronetTrafficInfo: ", e);
                }
            }
            RequestFinishedInfoImpl requestInfo = new RequestFinishedInfoImpl(this.mInitialUrl, this.mRequestAnnotations, (RequestFinishedInfo.Metrics)this.mMetrics, this.mFinishedReason, (UrlResponseInfo)this.mResponseInfo, this.mException);
            this.mRequestContext.reportRequestFinished((RequestFinishedInfo)requestInfo, inflightCallbackCount);
            if (this.mRequestFinishedListener != null) {
                inflightCallbackCount.increment();
                try {
                    this.mRequestFinishedListener.getExecutor().execute(new Runnable(){
                        final /* synthetic */ RequestFinishedInfo val$requestInfo;
                        final /* synthetic */ RefCountDelegate val$inflightCallbackCount;
                        {
                            this.val$requestInfo = requestFinishedInfo;
                            this.val$inflightCallbackCount = refCountDelegate;
                        }

                        @Override
                        public void run() {
                            try {
                                CronetUrlRequest.this.mRequestFinishedListener.onRequestFinished(this.val$requestInfo);
                            }
                            catch (Exception e) {
                                Log.e(CronetUrlRequestContext.LOG_TAG, "Exception thrown from request finished listener", e);
                            }
                            finally {
                                this.val$inflightCallbackCount.decrement();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException failException) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", failException);
                    inflightCallbackCount.decrement();
                }
            }
        }
        finally {
            inflightCallbackCount.decrement();
        }
    }

    @VisibleForTesting
    static final class HeadersList
    extends ArrayList<Map.Entry<String, String>> {
        HeadersList() {
        }
    }

    static interface Natives {
        public long createRequestAdapter(CronetUrlRequest var1, long var2, String var4, int var5, boolean var6, boolean var7, boolean var8, int var9, boolean var10, int var11, int var12, long var13);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public boolean setHttpMethod(long var1, CronetUrlRequest var3, String var4);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public boolean addRequestHeader(long var1, CronetUrlRequest var3, String var4, String var5);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void start(long var1, CronetUrlRequest var3);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void followDeferredRedirect(long var1, CronetUrlRequest var3);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public boolean readData(long var1, CronetUrlRequest var3, ByteBuffer var4, int var5, int var6);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void destroy(long var1, CronetUrlRequest var3, boolean var4);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void getStatus(long var1, CronetUrlRequest var3, VersionSafeCallbacks.UrlRequestStatusListener var4);
    }

    private final class OnReadCompletedRunnable
    implements Runnable {
        ByteBuffer mByteBuffer;

        private OnReadCompletedRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CronetUrlRequest.this.checkCallingThread();
            ByteBuffer buffer = this.mByteBuffer;
            this.mByteBuffer = null;
            try {
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRead = true;
                }
                CronetUrlRequest.this.mCallback.onReadCompleted((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo, buffer);
            }
            catch (Exception e) {
                CronetUrlRequest.this.onCallbackException(e);
            }
        }
    }
}

