/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeAnimator;
import android.util.Log;
import org.chromium.base.AnimationFrameTimeHistogramJni;

public class AnimationFrameTimeHistogram {
    private static final String TAG = "AnimationFrameTimeHistogram";
    private static final int MAX_FRAME_TIME_NUM = 600;
    private final Recorder mRecorder = new Recorder();
    private final String mHistogramName;

    public static Animator.AnimatorListener getAnimatorRecorder(final String histogramName) {
        return new AnimatorListenerAdapter(){
            private final AnimationFrameTimeHistogram mAnimationFrameTimeHistogram;
            {
                this.mAnimationFrameTimeHistogram = new AnimationFrameTimeHistogram(histogramName);
            }

            public void onAnimationStart(Animator animation) {
                this.mAnimationFrameTimeHistogram.startRecording();
            }

            public void onAnimationEnd(Animator animation) {
                this.mAnimationFrameTimeHistogram.endRecording();
            }

            public void onAnimationCancel(Animator animation) {
                this.mAnimationFrameTimeHistogram.endRecording();
            }
        };
    }

    public AnimationFrameTimeHistogram(String histogramName) {
        this.mHistogramName = histogramName;
    }

    public void startRecording() {
        this.mRecorder.startRecording();
    }

    public void endRecording() {
        if (this.mRecorder.endRecording()) {
            AnimationFrameTimeHistogramJni.get().saveHistogram(this.mHistogramName, this.mRecorder.getFrameTimesMs(), this.mRecorder.getFrameTimesCount());
        }
        this.mRecorder.cleanUp();
    }

    static interface Natives {
        public void saveHistogram(String var1, long[] var2, int var3);
    }

    private static class Recorder
    implements TimeAnimator.TimeListener {
        private final TimeAnimator mAnimator = new TimeAnimator();
        private long[] mFrameTimesMs;
        private int mFrameTimesCount;

        private Recorder() {
            this.mAnimator.setTimeListener((TimeAnimator.TimeListener)this);
        }

        private void startRecording() {
            assert (!this.mAnimator.isRunning());
            this.mFrameTimesCount = 0;
            this.mFrameTimesMs = new long[600];
            this.mAnimator.start();
        }

        private boolean endRecording() {
            boolean succeeded = this.mAnimator.isStarted();
            this.mAnimator.end();
            return succeeded;
        }

        private long[] getFrameTimesMs() {
            return this.mFrameTimesMs;
        }

        private int getFrameTimesCount() {
            return this.mFrameTimesCount;
        }

        private void cleanUp() {
            this.mFrameTimesMs = null;
        }

        public void onTimeUpdate(TimeAnimator animation, long totalTime, long deltaTime) {
            if (this.mFrameTimesCount == this.mFrameTimesMs.length) {
                this.mAnimator.end();
                this.cleanUp();
                Log.w((String)AnimationFrameTimeHistogram.TAG, (String)"Animation frame time recording reached the maximum number. It's eitherthe animation took too long or recording end is not called.");
                return;
            }
            if (deltaTime > 0L) {
                this.mFrameTimesMs[this.mFrameTimesCount++] = deltaTime;
            }
        }
    }
}

