/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.os.StatFs;
import android.os.StrictMode;
import android.os.UserManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.ImageViewCompat;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textclassifier.TextClassifier;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.chromium.base.FileUtils;
import org.chromium.base.ThreadUtils;

@TargetApi(value=21)
public class ApiCompatibilityUtils {
    private ApiCompatibilityUtils() {
    }

    public static int compareLong(long lhs, long rhs) {
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    public static int compareBoolean(boolean lhs, boolean rhs) {
        return lhs == rhs ? 0 : (lhs ? 1 : -1);
    }

    @NonNull
    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    @NonNull
    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static byte[] getBytesUtf8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.", e);
        }
    }

    public static boolean isPrintingSupported() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static boolean isElevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static String toHtml(Spanned spanned, int option) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.toHtml((Spanned)spanned, (int)option);
        }
        return Html.toHtml((Spanned)spanned);
    }

    public static void finishAndRemoveTask(Activity activity) {
        if (Build.VERSION.SDK_INT > 21) {
            activity.finishAndRemoveTask();
        } else if (Build.VERSION.SDK_INT == 21) {
            new FinishAndRemoveTaskWithRetry(activity).run();
        } else {
            activity.finish();
        }
    }

    @TargetApi(value=21)
    public static boolean setElevation(View view, float elevationValue) {
        if (!ApiCompatibilityUtils.isElevationSupported()) {
            return false;
        }
        view.setElevation(elevationValue);
        return true;
    }

    @TargetApi(value=21)
    public static boolean setElevation(PopupWindow window, float elevationValue) {
        if (!ApiCompatibilityUtils.isElevationSupported()) {
            return false;
        }
        window.setElevation(elevationValue);
        return true;
    }

    public static Intent getNotificationSettingsIntent(Context context) {
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= 26) {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        } else {
            intent.setAction("android.settings.ACTION_APP_NOTIFICATION_SETTINGS");
            intent.putExtra("app_package", context.getPackageName());
            intent.putExtra("app_uid", context.getApplicationInfo().uid);
        }
        return intent;
    }

    public static boolean isInteractive(Context context) {
        PowerManager manager = (PowerManager)context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 20) {
            return manager.isInteractive();
        }
        return manager.isScreenOn();
    }

    public static int getActivityNewDocumentFlag() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 524288;
        }
        return 524288;
    }

    public static boolean shouldSkipFirstUseHints(ContentResolver contentResolver) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Settings.Secure.getInt((ContentResolver)contentResolver, (String)"skip_first_use_hints", (int)0) != 0;
        }
        return false;
    }

    public static void setTaskDescription(Activity activity, String title, Bitmap icon, int color2) {
        assert (Color.alpha((int)color2) == 255);
        if (Build.VERSION.SDK_INT >= 21) {
            ActivityManager.TaskDescription description = new ActivityManager.TaskDescription(title, icon, color2);
            activity.setTaskDescription(description);
        }
    }

    public static void setStatusBarColor(Window window, int statusBarColor) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (Build.VERSION.SDK_INT < 26 && statusBarColor == -16777216 && window.getNavigationBarColor() == -16777216) {
            window.clearFlags(Integer.MIN_VALUE);
        } else {
            window.addFlags(Integer.MIN_VALUE);
        }
        window.setStatusBarColor(statusBarColor);
    }

    public static void setStatusBarIconColor(View rootView, boolean useDarkIcons) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        int systemUiVisibility = rootView.getSystemUiVisibility();
        systemUiVisibility = useDarkIcons ? (systemUiVisibility |= 0x2000) : (systemUiVisibility &= 0xFFFFDFFF);
        rootView.setSystemUiVisibility(systemUiVisibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(Resources res, int id2) throws Resources.NotFoundException {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Drawable drawable2 = res.getDrawable(id2, null);
                return drawable2;
            }
            Drawable drawable3 = res.getDrawable(id2);
            return drawable3;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    public static void setImageTintList(@NonNull ImageView view, @Nullable ColorStateList tintList) {
        if (Build.VERSION.SDK_INT == 21 && tintList != null && view.getImageTintMode() == null) {
            view.setImageTintMode(PorterDuff.Mode.SRC_IN);
        }
        ImageViewCompat.setImageTintList((ImageView)view, (ColorStateList)tintList);
    }

    public static Drawable getDrawableForDensity(Resources res, int id2, int density) {
        if (Build.VERSION.SDK_INT >= 21) {
            return res.getDrawableForDensity(id2, density, null);
        }
        return res.getDrawableForDensity(id2, density);
    }

    public static void finishAfterTransition(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.finishAfterTransition();
        } else {
            activity.finish();
        }
    }

    public static Drawable getUserBadgedIcon(Context context, int id2) {
        Drawable drawable2 = ApiCompatibilityUtils.getDrawable(context.getResources(), id2);
        if (Build.VERSION.SDK_INT >= 21) {
            PackageManager packageManager = context.getPackageManager();
            drawable2 = packageManager.getUserBadgedIcon(drawable2, Process.myUserHandle());
        }
        return drawable2;
    }

    public static Drawable getUserBadgedDrawableForDensity(Context context, Drawable drawable2, Rect badgeLocation, int density) {
        if (Build.VERSION.SDK_INT >= 21) {
            PackageManager packageManager = context.getPackageManager();
            return packageManager.getUserBadgedDrawableForDensity(drawable2, Process.myUserHandle(), badgeLocation, density);
        }
        return drawable2;
    }

    public static int getColor(Resources res, int id2) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 23) {
            return res.getColor(id2, null);
        }
        return res.getColor(id2);
    }

    public static ColorFilter getColorFilter(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return drawable2.getColorFilter();
        }
        return null;
    }

    public static void setTextAppearance(TextView view, int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            view.setTextAppearance(id2);
        } else {
            view.setTextAppearance(view.getContext(), id2);
        }
    }

    public static long getAvailableBlocks(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 19) {
            return statFs.getAvailableBlocksLong();
        }
        return statFs.getAvailableBlocks();
    }

    public static long getBlockCount(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 19) {
            return statFs.getBlockCountLong();
        }
        return statFs.getBlockCount();
    }

    public static long getBlockSize(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 19) {
            return statFs.getBlockSizeLong();
        }
        return statFs.getBlockSize();
    }

    public static boolean isDemoUser(Context context) {
        if (Build.VERSION.SDK_INT < 25) {
            return false;
        }
        UserManager userManager = (UserManager)context.getSystemService("user");
        return userManager.isDemoUser();
    }

    public static int checkPermission(Context context, String permission, int pid, int uid) {
        try {
            return context.checkPermission(permission, pid, uid);
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public static String getLocale(InputMethodSubtype inputMethodSubType) {
        if (Build.VERSION.SDK_INT >= 24) {
            return inputMethodSubType.getLanguageTag();
        }
        return inputMethodSubType.getLocale();
    }

    public static Uri getUriForDownloadedFile(File file) {
        return Build.VERSION.SDK_INT > 23 ? FileUtils.getUriForFile(file) : Uri.fromFile((File)file);
    }

    public static void setWindowIndeterminateProgress(Window window) {
        if (Build.VERSION.SDK_INT < 21) {
            int featureNumber = 5;
            int featureValue = -2;
            window.setFeatureInt(featureNumber, featureValue);
        }
    }

    public static boolean isInMultiWindowMode(Activity activity) {
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        return activity.isInMultiWindowMode();
    }

    @TargetApi(value=26)
    public static void disableSmartSelectionTextClassifier(TextView textView) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        textView.setTextClassifier(TextClassifier.NO_OP);
    }

    public static Bundle createLaunchDisplayIdActivityOptions(int displayId) {
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        ActivityOptions options = ActivityOptions.makeBasic();
        options.setLaunchDisplayId(displayId);
        return options.toBundle();
    }

    public static void setAccessibilityTraversalBefore(View view, int viewFocusedAfter) {
        if (Build.VERSION.SDK_INT >= 22) {
            view.setAccessibilityTraversalBefore(viewFocusedAfter);
        }
    }

    public static LayerDrawable createLayerDrawable(@NonNull Drawable[] layers) {
        if (Build.VERSION.SDK_INT <= 19) {
            return new LayerDrawableCompat(layers);
        }
        return new LayerDrawable(layers);
    }

    public static TransitionDrawable createTransitionDrawable(@NonNull Drawable[] layers) {
        if (Build.VERSION.SDK_INT <= 19) {
            return new TransitionDrawableCompat(layers);
        }
        return new TransitionDrawable(layers);
    }

    public static void setPasswordEditTextContentDescription(EditText view) {
        if (Build.VERSION.SDK_INT >= 24) {
            return;
        }
        if (ApiCompatibilityUtils.isPasswordInputType(view.getInputType()) && !TextUtils.isEmpty((CharSequence)view.getHint())) {
            view.setContentDescription(view.getHint());
        }
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private static Rect[] getLayersBounds(LayerDrawable layerDrawable) {
        Rect[] result = new Rect[layerDrawable.getNumberOfLayers()];
        for (int i = 0; i < layerDrawable.getNumberOfLayers(); ++i) {
            result[i] = layerDrawable.getDrawable(i).getBounds();
        }
        return result;
    }

    private static void restoreLayersBounds(LayerDrawable layerDrawable, Rect[] oldBounds) {
        assert (layerDrawable.getNumberOfLayers() == oldBounds.length);
        for (int i = 0; i < layerDrawable.getNumberOfLayers(); ++i) {
            layerDrawable.getDrawable(i).setBounds(oldBounds[i]);
        }
    }

    private static class TransitionDrawableCompat
    extends TransitionDrawable {
        private boolean mMutated;

        TransitionDrawableCompat(@NonNull Drawable[] layers) {
            super(layers);
        }

        @NonNull
        public Drawable mutate() {
            if (this.mMutated) {
                return this;
            }
            Rect[] oldBounds = ApiCompatibilityUtils.getLayersBounds((LayerDrawable)this);
            Drawable superResult = super.mutate();
            if (superResult != this) {
                return superResult;
            }
            ApiCompatibilityUtils.restoreLayersBounds((LayerDrawable)this, oldBounds);
            this.mMutated = true;
            return this;
        }
    }

    private static class LayerDrawableCompat
    extends LayerDrawable {
        private boolean mMutated;

        LayerDrawableCompat(@NonNull Drawable[] layers) {
            super(layers);
        }

        @NonNull
        public Drawable mutate() {
            if (this.mMutated) {
                return this;
            }
            Rect[] oldBounds = ApiCompatibilityUtils.getLayersBounds(this);
            Drawable superResult = super.mutate();
            if (superResult != this) {
                return superResult;
            }
            ApiCompatibilityUtils.restoreLayersBounds(this, oldBounds);
            this.mMutated = true;
            return this;
        }
    }

    private static class FinishAndRemoveTaskWithRetry
    implements Runnable {
        private static final long RETRY_DELAY_MS = 500L;
        private static final long MAX_TRY_COUNT = 3L;
        private final Activity mActivity;
        private int mTryCount;

        FinishAndRemoveTaskWithRetry(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void run() {
            this.mActivity.finishAndRemoveTask();
            ++this.mTryCount;
            if (!this.mActivity.isFinishing()) {
                if ((long)this.mTryCount < 3L) {
                    ThreadUtils.postOnUiThreadDelayed(this, 500L);
                } else {
                    this.mActivity.finish();
                }
            }
        }
    }
}

