/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import org.chromium.base.BuildConfig;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;

public class BuildInfo {
    private static final String TAG = "BuildInfo";
    private static final int MAX_FINGERPRINT_LENGTH = 128;
    private static PackageInfo sBrowserPackageInfo;
    private static boolean sInitialized;
    private static String sFirebaseAppId;
    public final String hostPackageLabel;
    public final int hostVersionCode;
    public final String packageName;
    public final int versionCode;
    public final String versionName;
    public final String installerPackageName;
    public final String gmsVersionCode;
    public final String abiString;
    public final String androidBuildFingerprint;
    public final String extractedFileSuffix;
    public final String customThemes;
    public final String resourcesVersion;

    @CalledByNative
    private static String[] getAll() {
        BuildInfo buildInfo = BuildInfo.getInstance();
        String hostPackageName = ContextUtils.getApplicationContext().getPackageName();
        return new String[]{Build.BRAND, Build.DEVICE, Build.ID, Build.MANUFACTURER, Build.MODEL, String.valueOf(Build.VERSION.SDK_INT), Build.TYPE, Build.BOARD, hostPackageName, String.valueOf(buildInfo.hostVersionCode), buildInfo.hostPackageLabel, buildInfo.packageName, String.valueOf(buildInfo.versionCode), buildInfo.versionName, buildInfo.androidBuildFingerprint, buildInfo.gmsVersionCode, buildInfo.installerPackageName, buildInfo.abiString, sFirebaseAppId, buildInfo.customThemes, buildInfo.resourcesVersion, buildInfo.extractedFileSuffix, BuildInfo.isAtLeastQ() ? "1" : "0"};
    }

    private static String nullToEmpty(CharSequence seq) {
        return seq == null ? "" : seq.toString();
    }

    public static void setBrowserPackageInfo(PackageInfo packageInfo) {
        assert (!sInitialized);
        sBrowserPackageInfo = packageInfo;
    }

    public static BuildInfo getInstance() {
        return Holder.sInstance;
    }

    private BuildInfo() {
        sInitialized = true;
        try {
            Context appContext = ContextUtils.getApplicationContext();
            String hostPackageName = appContext.getPackageName();
            PackageManager pm = appContext.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(hostPackageName, 0);
            this.hostVersionCode = pi.versionCode;
            if (sBrowserPackageInfo != null) {
                this.packageName = BuildInfo.sBrowserPackageInfo.packageName;
                this.versionCode = BuildInfo.sBrowserPackageInfo.versionCode;
                this.versionName = BuildInfo.nullToEmpty(BuildInfo.sBrowserPackageInfo.versionName);
                sBrowserPackageInfo = null;
            } else {
                this.packageName = hostPackageName;
                this.versionCode = this.hostVersionCode;
                this.versionName = BuildInfo.nullToEmpty(pi.versionName);
            }
            this.hostPackageLabel = BuildInfo.nullToEmpty(pm.getApplicationLabel(pi.applicationInfo));
            this.installerPackageName = BuildInfo.nullToEmpty(pm.getInstallerPackageName(this.packageName));
            PackageInfo gmsPackageInfo = null;
            try {
                gmsPackageInfo = pm.getPackageInfo("com.google.android.gms", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.d(TAG, "GMS package is not found.", (Object)e);
            }
            this.gmsVersionCode = gmsPackageInfo != null ? String.valueOf(gmsPackageInfo.versionCode) : "gms versionCode not available.";
            String hasCustomThemes = "true";
            try {
                pm.getPackageInfo("projekt.substratum", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                hasCustomThemes = "false";
            }
            this.customThemes = hasCustomThemes;
            String currentResourcesVersion = "Not Enabled";
            if (BuildConfig.R_STRING_PRODUCT_VERSION != 0) {
                try {
                    currentResourcesVersion = ContextUtils.getApplicationContext().getString(BuildConfig.R_STRING_PRODUCT_VERSION);
                }
                catch (Exception e) {
                    currentResourcesVersion = "Not found";
                }
            }
            this.resourcesVersion = currentResourcesVersion;
            this.abiString = Build.VERSION.SDK_INT >= 21 ? TextUtils.join((CharSequence)", ", (Object[])Build.SUPPORTED_ABIS) : String.format("ABI1: %s, ABI2: %s", Build.CPU_ABI, Build.CPU_ABI2);
            this.extractedFileSuffix = String.format("@%x_%x", this.versionCode, pi.lastUpdateTime);
            this.androidBuildFingerprint = Build.FINGERPRINT.substring(0, Math.min(Build.FINGERPRINT.length(), 128));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDebugAndroid() {
        return "eng".equals(Build.TYPE) || "userdebug".equals(Build.TYPE);
    }

    public static boolean isAtLeastQ() {
        return Build.VERSION.SDK_INT >= 29;
    }

    public static boolean targetsAtLeastQ() {
        return ContextUtils.getApplicationContext().getApplicationInfo().targetSdkVersion >= 29;
    }

    public static void setFirebaseAppId(String id2) {
        assert (sFirebaseAppId.equals(""));
        sFirebaseAppId = id2;
    }

    public static String getFirebaseAppId() {
        return sFirebaseAppId;
    }

    static {
        sFirebaseAppId = "";
    }

    private static class Holder {
        private static BuildInfo sInstance = new BuildInfo();

        private Holder() {
        }
    }
}

