/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import dalvik.system.BaseDexClassLoader;
import org.chromium.base.ContextUtils;
import org.chromium.base.StrictModeContext;
import org.chromium.base.annotations.CalledByNative;

public class BundleUtils {
    private static final boolean sIsBundle;

    @CalledByNative
    public static boolean isBundle() {
        return sIsBundle;
    }

    @CalledByNative
    private static String getNativeLibraryPath(String libraryName) {
        try (StrictModeContext unused = StrictModeContext.allowDiskReads();){
            String string2 = ((BaseDexClassLoader)ContextUtils.getApplicationContext().getClassLoader()).findLibrary(libraryName);
            return string2;
        }
    }

    static {
        boolean isBundle;
        try {
            Class.forName("org.chromium.base.BundleCanary");
            isBundle = true;
        }
        catch (ClassNotFoundException e) {
            isBundle = false;
        }
        sIsBundle = isBundle;
    }
}

