/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.os.Process;
import android.preference.PreferenceManager;
import org.chromium.base.BuildConfig;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
public class ContextUtils {
    private static final String TAG = "ContextUtils";
    private static Context sApplicationContext;
    private static String sProcessName;

    public static Context getApplicationContext() {
        return sApplicationContext;
    }

    @MainDex
    public static void initApplicationContext(Context appContext) {
        assert (sApplicationContext == null || sApplicationContext == appContext || ((ContextWrapper)sApplicationContext).getBaseContext() == appContext);
        ContextUtils.initJavaSideApplicationContext(appContext);
    }

    private static SharedPreferences fetchAppSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)sApplicationContext);
    }

    public static SharedPreferences getAppSharedPreferences() {
        return Holder.sSharedPreferences;
    }

    @VisibleForTesting
    public static void initApplicationContextForTests(Context appContext) {
        ContextUtils.initJavaSideApplicationContext(appContext);
        Holder.sSharedPreferences = ContextUtils.fetchAppSharedPreferences();
    }

    private static void initJavaSideApplicationContext(Context appContext) {
        assert (appContext != null);
        if (BuildConfig.DCHECK_IS_ON && appContext instanceof Application) {
            appContext = new ContextWrapper(appContext);
        }
        sApplicationContext = appContext;
    }

    public static AssetManager getApplicationAssets() {
        Context context = ContextUtils.getApplicationContext();
        while (context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context.getAssets();
    }

    public static boolean isIsolatedProcess() {
        try {
            return (Boolean)Process.class.getMethod("isIsolated", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getProcessName() {
        if (sProcessName != null) {
            return sProcessName;
        }
        try {
            Class<?> activityThreadClazz = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClazz.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            sProcessName = (String)activityThreadClazz.getMethod("getProcessName", new Class[0]).invoke(activityThread, new Object[0]);
            return sProcessName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ SharedPreferences access$000() {
        return ContextUtils.fetchAppSharedPreferences();
    }

    private static class Holder {
        private static SharedPreferences sSharedPreferences = ContextUtils.access$000();

        private Holder() {
        }
    }
}

